create table `customer`(
    `id`           bigint(20)  NOT NULL AUTO_INCREMENT,
    `num`          varchar(16) NOT NULL COLLATE utf8mb4_bin COMMENT '对外展示唯一标识',
    `biz_id`       bigint(20)  NOT NULL COMMENT '商户id',
    `corp_id`      varchar(64) NOT NULL COMMENT '企业ID',
    `main_num`     varchar(16) COMMENT '关联的主要customer.num',
    `id_type`      int(10)     NOT NULL COMMENT '客户id类型',
    `id1`          varchar(64) NOT NULL COLLATE utf8mb4_bin COMMENT '客户标识1',
    `id2`          varchar(64) NOT NULL DEFAULT '' COLLATE utf8mb4_bin COMMENT '客户标识2',
    `union_id`     varchar(64) COLLATE utf8mb4_bin COMMENT '微信UNION_ID',
    `create_by`    bigint(20)  NOT NULL DEFAULT '-1' COMMENT '创建人id',
    `create_time`  datetime    NOT NULL COMMENT '创建时间',
    `update_by`    bigint(20)  NOT NULL DEFAULT '-1' COMMENT '更新人id',
    `update_time`  datetime    NOT NULL COMMENT '更新时间',
    primary key(id),
    UNIQUE KEY unq_num(num),
    UNIQUE KEY unq_id(biz_id, id_type, id1, id2),
    index idx_main_num(biz_id, main_num),
    index idx_union_id(biz_id, union_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='客户标识';