/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.customer.service.impl;

import cn.kinyun.customer.center.dal.util.BizTableContext;
import cn.kinyun.customer.center.dto.req.BaseBatchReq;
import cn.kinyun.customer.center.dto.req.BaseReq;
import cn.kinyun.customer.center.sal.customer.service.BizInitService;
import java.util.Stack;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class BizIdAspect {
    private static final Logger log = LoggerFactory.getLogger(BizIdAspect.class);
    private final ThreadLocal<Stack<Long>> timestamp = new ThreadLocal();
    @Autowired
    private BizInitService bizInitService;

    @Before(value="execution(* cn.kinyun.customer.center.service.*.*(..))")
    public void initBizId(JoinPoint joinPoint) {
        log.info("{}, args:{}", (Object)joinPoint.getSignature(), (Object)joinPoint.getArgs());
        Stack<Long> s = this.timestamp.get();
        if (s == null) {
            s = new Stack();
            this.timestamp.set(s);
        }
        s.push(System.currentTimeMillis());
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        Object arg = args[0];
        Long bizId = null;
        if (arg instanceof Long) {
            bizId = (Long)arg;
        } else if (arg instanceof BaseReq) {
            BaseReq params = (BaseReq)arg;
            bizId = params.getBizId();
        } else if (arg instanceof BaseBatchReq) {
            BaseBatchReq params = (BaseBatchReq)arg;
            bizId = params.getBizId();
        } else {
            log.warn("bizId not found");
        }
        if (bizId != null && BizTableContext.getBizId() == null) {
            BizTableContext.putBizId((Long)bizId);
            log.info("Set biz table context, bizId={}", (Object)bizId);
            this.bizInitService.tryInit(bizId);
        }
    }

    @After(value="execution(* cn.kinyun.customer.center.service.*.*(..))")
    public void clearBizId(JoinPoint joinPoint) {
        Stack<Long> s = this.timestamp.get();
        Long time = s.pop();
        if (time != null) {
            log.info("{}, cost:{}ms", (Object)joinPoint.getSignature(), (Object)(System.currentTimeMillis() - time));
        }
        if (s.size() == 0) {
            BizTableContext.clear();
            this.timestamp.remove();
        }
    }
}

