/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.dal.util;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String YYYY_MM_DD_HH_MM_SS_EN = "yyyy-MM-dd HH:mm:ss";
    public static final String MM_DD = "MM/dd";
    public static final String YYYY_MM_DD_EN = "yyyy-MM-dd";
    private static final Map<String, FastDateFormat> DATE_FORMAT_MAP = new ConcurrentHashMap<String, FastDateFormat>();

    private DateUtil() {
    }

    public static Long getEndTime(Date date) {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.setTime(date);
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime().getTime();
    }

    public static Long getStartTime(Date date) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.setTime(date);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static List<String> betweenDayStr(String startTime, String endTime) {
        ArrayList<String> times = new ArrayList<String>();
        times.add(DateUtil.dateToDateString(DateUtil.getDate(endTime, YYYY_MM_DD_HH_MM_SS_EN), YYYY_MM_DD_EN));
        Date date1 = DateUtil.getDate(startTime, YYYY_MM_DD_HH_MM_SS_EN);
        Date date2 = DateUtil.getDate(endTime, YYYY_MM_DD_HH_MM_SS_EN);
        if (date1 == null || date2 == null) {
            return times;
        }
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(date1);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date2);
        while (date1.before(calEnd.getTime())) {
            calEnd.add(5, -1);
            if (!date1.before(calEnd.getTime())) continue;
            times.add(DateUtil.dateToDateString(calEnd.getTime(), YYYY_MM_DD_EN));
        }
        return times;
    }

    public static List<String> betweenDays(Date startTime, Date endTime) {
        ArrayList<String> times = new ArrayList<String>();
        times.add(DateUtil.dateToDateString(startTime, MM_DD));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(startTime);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(endTime);
        while (endTime.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            if (!endTime.after(calBegin.getTime())) continue;
            times.add(DateUtil.dateToDateString(calBegin.getTime(), MM_DD));
        }
        return times;
    }

    public static Date getDate(String dateTimeStr, String formatStr) {
        try {
            if (dateTimeStr == null || dateTimeStr.equals("")) {
                return null;
            }
            FastDateFormat sdf = DateUtil.getDateFormat(formatStr);
            return sdf.parse(dateTimeStr);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static FastDateFormat getDateFormat(String formatStr) {
        FastDateFormat df = DATE_FORMAT_MAP.get(formatStr);
        if (df == null) {
            df = FastDateFormat.getInstance((String)formatStr);
            DATE_FORMAT_MAP.put(formatStr, df);
        }
        return df;
    }

    public static String dateToDateString(Date date, String formatStr) {
        if (formatStr == null) {
            formatStr = YYYY_MM_DD_HH_MM_SS_EN;
        }
        FastDateFormat df = DateUtil.getDateFormat(formatStr);
        return df.format(date);
    }

    public static long getMonthsBetween(Date startDate, Date endDate) {
        LocalDate startLocalDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endLocalDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return ChronoUnit.MONTHS.between(startLocalDate, endLocalDate);
    }
}

