/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.dal.util;

import cn.kinyun.customer.center.dal.util.SqlToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TableNameParser {
    private static final String TOKEN_GROUP_START = "(";
    private static final String TOKEN_COMMA = ",";
    private static final String TOKEN_SET = "set";
    private static final String TOKEN_OF = "of";
    private static final String TOKEN_DUAL = "dual";
    private static final String TOKEN_DELETE = "delete";
    private static final String TOKEN_CREATE = "create";
    private static final String TOKEN_INDEX = "index";
    private static final String TOKEN_ALL = "*";
    private static final String KEYWORD_JOIN = "join";
    private static final String KEYWORD_INTO = "into";
    private static final String KEYWORD_TABLE = "table";
    private static final String KEYWORD_FROM = "from";
    private static final String KEYWORD_USING = "using";
    private static final String KEYWORD_UPDATE = "update";
    private static final String KEYWORD_DUPLICATE = "duplicate";
    private static final List<String> concerned = Arrays.asList("table", "into", "join", "using", "update");
    private static final List<String> ignored = Arrays.asList("(", "set", "of", "dual");
    private static final Pattern NON_SQL_TOKEN_PATTERN = Pattern.compile("(--[^\\v]+)|;|(\\s+)|((?s)/[*].*?[*]/)|(((\\b|\\B)(?=[,()]))|((?<=[,()])(\\b|\\B)))");
    private final List<SqlToken> tokens;

    public TableNameParser(String sql) {
        this.tokens = this.fetchAllTokens(sql);
    }

    public void accept(TableNameVisitor visitor) {
        int index = 0;
        String first = this.tokens.get(index).getValue();
        if (TableNameParser.isOracleSpecialDelete(first, this.tokens, index)) {
            TableNameParser.visitNameToken(this.tokens.get(index + 1), visitor);
        } else if (this.isCreateIndex(first, this.tokens, index)) {
            TableNameParser.visitNameToken(this.tokens.get(index + 4), visitor);
        } else {
            while (TableNameParser.hasMoreTokens(this.tokens, index)) {
                String current;
                if (TableNameParser.isFromToken(current = this.tokens.get(index++).getValue())) {
                    TableNameParser.processFromToken(this.tokens, index, visitor);
                    continue;
                }
                if (this.isOnDuplicateKeyUpdate(current, index)) {
                    index = this.skipDuplicateKeyUpdateIndex(index);
                    continue;
                }
                if (!concerned.contains(current.toLowerCase(Locale.getDefault())) || !TableNameParser.hasMoreTokens(this.tokens, index)) continue;
                SqlToken next = this.tokens.get(index++);
                TableNameParser.visitNameToken(next, visitor);
            }
        }
    }

    List<SqlToken> fetchAllTokens(String sql) {
        ArrayList<SqlToken> list = new ArrayList<SqlToken>();
        Matcher matcher = NON_SQL_TOKEN_PATTERN.matcher(sql);
        int last = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (start != last) {
                list.add(new SqlToken(last, start, sql.substring(last, start)));
            }
            last = matcher.end();
        }
        if (last != sql.length()) {
            list.add(new SqlToken(last, sql.length(), sql.substring(last)));
        }
        return list;
    }

    private static boolean isOracleSpecialDelete(String current, List<SqlToken> tokens, int index) {
        if (TOKEN_DELETE.equalsIgnoreCase(current) && TableNameParser.hasMoreTokens(tokens, index++)) {
            String next = tokens.get(index).getValue();
            return !KEYWORD_FROM.equalsIgnoreCase(next) && !TOKEN_ALL.equals(next);
        }
        return false;
    }

    private boolean isCreateIndex(String current, List<SqlToken> tokens, int index) {
        if (TOKEN_CREATE.equalsIgnoreCase(current) && TableNameParser.hasIthToken(tokens, ++index)) {
            String next = tokens.get(index).getValue();
            return TOKEN_INDEX.equalsIgnoreCase(next);
        }
        return false;
    }

    private boolean isOnDuplicateKeyUpdate(String current, int index) {
        if (KEYWORD_DUPLICATE.equalsIgnoreCase(current) && TableNameParser.hasMoreTokens(this.tokens, index++)) {
            String next = this.tokens.get(index).getValue();
            return KEYWORD_UPDATE.equalsIgnoreCase(next);
        }
        return false;
    }

    private static boolean hasIthToken(List<SqlToken> tokens, int currentIndex) {
        return TableNameParser.hasMoreTokens(tokens, currentIndex) && tokens.size() > currentIndex + 3;
    }

    private static boolean isFromToken(String currentToken) {
        return KEYWORD_FROM.equalsIgnoreCase(currentToken);
    }

    private int skipDuplicateKeyUpdateIndex(int index) {
        return index + 2;
    }

    private static void processFromToken(List<SqlToken> tokens, int index, TableNameVisitor visitor) {
        SqlToken sqlToken = tokens.get(index++);
        TableNameParser.visitNameToken(sqlToken, visitor);
        String next = null;
        if (TableNameParser.hasMoreTokens(tokens, index)) {
            next = tokens.get(index++).getValue();
        }
        if (TableNameParser.shouldProcessMultipleTables(next)) {
            TableNameParser.processNonAliasedMultiTables(tokens, index, next, visitor);
        } else {
            TableNameParser.processAliasedMultiTables(tokens, index, sqlToken, visitor);
        }
    }

    private static void processNonAliasedMultiTables(List<SqlToken> tokens, int index, String nextToken, TableNameVisitor visitor) {
        while (nextToken.equals(TOKEN_COMMA)) {
            TableNameParser.visitNameToken(tokens.get(index++), visitor);
            if (!TableNameParser.hasMoreTokens(tokens, index)) break;
            nextToken = tokens.get(index++).getValue();
        }
    }

    private static void processAliasedMultiTables(List<SqlToken> tokens, int index, SqlToken current, TableNameVisitor visitor) {
        String nextNextToken = null;
        if (TableNameParser.hasMoreTokens(tokens, index)) {
            nextNextToken = tokens.get(index++).getValue();
        }
        if (TableNameParser.shouldProcessMultipleTables(nextNextToken)) {
            while (TableNameParser.hasMoreTokens(tokens, index) && nextNextToken.equals(TOKEN_COMMA)) {
                if (TableNameParser.hasMoreTokens(tokens, index)) {
                    current = tokens.get(index++);
                }
                if (TableNameParser.hasMoreTokens(tokens, index)) {
                    ++index;
                }
                if (TableNameParser.hasMoreTokens(tokens, index)) {
                    nextNextToken = tokens.get(index++).getValue();
                }
                TableNameParser.visitNameToken(current, visitor);
            }
        }
    }

    private static boolean shouldProcessMultipleTables(String nextToken) {
        return nextToken != null && nextToken.equals(TOKEN_COMMA);
    }

    private static boolean hasMoreTokens(List<SqlToken> tokens, int index) {
        return index < tokens.size();
    }

    private static void visitNameToken(SqlToken token, TableNameVisitor visitor) {
        String value = token.getValue().toLowerCase(Locale.getDefault());
        if (!ignored.contains(value)) {
            visitor.visit(token);
        }
    }

    public Collection<String> tables() {
        HashMap tableMap = new HashMap();
        this.accept(token -> {
            String name = token.getValue();
            tableMap.putIfAbsent(name.toLowerCase(Locale.getDefault()), name);
        });
        return new HashSet<String>(tableMap.values());
    }

    public static interface TableNameVisitor {
        public void visit(SqlToken var1);
    }
}

