/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.dal.interceptor;

import cn.kinyun.customer.center.dal.util.BizTableContext;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class})})
public class DynamicTableNameInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicTableNameInterceptor.class);
    private Set<String> tables = Collections.emptySet();
    private boolean isEnabled;

    public void setProperties(Properties properties) {
        String enable = properties.getProperty("enable", "true");
        if ("true".equalsIgnoreCase(enable)) {
            this.isEnabled = true;
        }
        if (this.isEnabled) {
            String tableNames = properties.getProperty("tableNames");
            if (StringUtils.isNotBlank((CharSequence)tableNames)) {
                log.info("\u52a8\u6001\u5206\u8868:{}", (Object)tableNames);
                String[] names = StringUtils.split((String)tableNames, (char)',');
                this.tables = new HashSet<String>();
                for (String name : names) {
                    this.tables.add(name.toLowerCase(Locale.getDefault()));
                }
            } else {
                log.info("\u7531\u4e8e\u672a\u914d\u7f6e\u8868\u540d\uff0c\u52a8\u6001\u5206\u8868\u63d2\u4ef6\u5df2\u88ab\u5173\u95ed\u3002");
                this.isEnabled = false;
            }
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (!this.isEnabled) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = this.changeSql(boundSql.getSql());
        MetaObject boundSqlMeta = SystemMetaObject.forObject((Object)boundSql);
        boundSqlMeta.setValue("sql", (Object)sql);
        return invocation.proceed();
    }

    public String changeSql(String sql) {
        TableNameParser parser = new TableNameParser(sql);
        ArrayList names = new ArrayList();
        parser.accept(names::add);
        StringBuilder builder = new StringBuilder();
        int last = 0;
        for (TableNameParser.SqlToken name : names) {
            int start = name.getStart();
            if (start != last) {
                builder.append(sql, last, start);
                String value = name.getValue();
                builder.append(this.changeTableName(value));
            }
            last = name.getEnd();
        }
        if (last != sql.length()) {
            builder.append(sql.substring(last));
        }
        return builder.toString();
    }

    public String changeTableName(String tableName) {
        String name = tableName.toLowerCase(Locale.getDefault());
        if (name.startsWith("`")) {
            name = name.substring(1);
        }
        if (name.endsWith("`")) {
            name = name.substring(0, name.length() - 1);
        }
        if (!this.tables.contains(name)) {
            return tableName;
        }
        Long bizId = BizTableContext.getBizId();
        if (bizId == null) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u5546\u6237id\uff0c\u8bf7\u5728\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c\u524d\uff0c\u5148\u8c03\u7528 BizTableContext.putBizId(Long) \u8bbe\u7f6e\u5546\u6237ID\u3002");
        }
        String newName = "`" + name + "_" + bizId + "`";
        log.debug("change table name:{} -> {}", (Object)name, (Object)newName);
        return newName;
    }
}

