package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @Date: 2021/12/20 17:14
 * @Author: dayu
 */
@Data
public class CustomerDetailReq extends BaseReq {

    private String avatar;

    private String name;

    private String area;

    private String corpName;

    private String corpFullName;

    private Integer type;

    private Integer gender;

    private String remark;

    private String channelId;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(customerNum), "customerNum不能为空");
    }
}
