package cn.kinyun.customer.center.enums;

public enum OrderEntryMethodEnum {


    //    //
    MANUAL(1, "手动录入"),
    // 有效
    OTHER(0, "其他方式录入");

    private int value;
    private String name;

    OrderEntryMethodEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }


    public Integer getValue() {
        return value;
    }


    public String getName() {
        return name;
    }

    public static OrderEntryMethodEnum getByValue( Integer value) {
        if (value == null) return null;

        for (OrderEntryMethodEnum item : OrderEntryMethodEnum.values()) {
            if (value.equals(item.getValue())) {
                return item;
            }
        }
        return null;
    }
}
