package cn.kinyun.customer.center.enums.electricity;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * 退款原因，有赞
 **/
public enum YzRefundReasonEnum implements EnumService {
    COMMON_CONSENSUS(1, "COMMON_CONSENSUS", "买/卖双方协商一致"),
    COMMON_BUYWRONG(2, "COMMON_BUYWRONG", "买错/多买/不想要"),
    COMMON_QUALITY(3, "COMMON_QUALITY", "商品质量问题"),
    COMMON_NOTRECEIVE(4, "COMMON_NOTRECEIVE", "未收到货品"),
    COMMON_OTHER(5, "COMMON_OTHER", "其他"),
    REFUND_QUALITY(6, "REFUND_QUALITY", "质量问题"),
    REFUND_BUYWRONG(7, "REFUND_BUYWRONG", "拍错/多拍/不喜欢"),
    REFUND_INCONFORMITY(8, "REFUND_INCONFORMITY", "商品描述不符"),
    REFUND_FAKE(9, "REFUND_FAKE", "假货"),
    REFUND_SENDWRONG(10, "REFUND_SENDWRONG", "商家发错货"),
    REFUND_GOODSLESS(11, "REFUND_GOODSLESS", "商品破损/少件"),
    REFUND_OTHER(12, "REFUND_OTHER", "其他"),
    RETURN_FREIGHT(13, "RETURN_FREIGHT", "退运费"),
    CONSULT_OK(14, "CONSULT_OK", "协商一致退款"),
    NOT_BEEN_DELIVERED(15, "NOT_BEEN_DELIVERED", "快递一直未送达"),
    SEND_GOODS_FAIL_APPOINTMENT_GOODS(16, "SEND_GOODS_FAIL_APPOINTMENT_GOODS", "未按约定时间发货"),
    WRONG_BUY_OR_DONT_WANT(17, "WRONG_BUY_OR_DONT_WANT", "拍错/不想要"),
    PLAN_CHANGED(18, "PLAN_CHANGED", "计划有变无法使用"),
    SELLER_DISCOUNT(19, "SELLER_DISCOUNT", "商家降价"),
    NOT_REAL_ORIGIN2(20, "NOT_REAL_ORIGIN2", "非正品"),
    RETURNSNOT_BUYWRONG(21, "RETURNSNOT_BUYWRONG", "多买/买错/不想要"),
    RETURNSNOT_NULLEXPRESS(22, "RETURNSNOT_NULLEXPRESS", "快递无记录"),
    RETURNSNOT_GOODSLESS(23, "RETURNSNOT_GOODSLESS", "少货/空包裹"),
    RETURNSNOT_NOTEXPRESS_ONTIME(24, "RETURNSNOT_NOTEXPRESS_ONTIME", "未按约定时间发货"),
    RETURNSNOT_NOTRECEIVE(25, "RETURNSNOT_NOTRECEIVE", "快递一直未送达"),
    RETURNSNOT_OTHER(26, "RETURNSNOT_OTHER", "快递一直未送达"),
    PAT_ERROR_OR_MORE_OR_DOT_NO_GOODS(27, "PAT_ERROR_OR_MORE_OR_DOT_NO_GOODS", "拍错/多拍/不喜欢"),
    CONSULT_OK_NO_GOODS(28, "CONSULT_OK_NO_GOODS", "协商一致退款"),
    RETURNS_GOODSLESS(29, "RETURNS_GOODSLESS", "商品破损/少件"),
    RETURNS_SENDWRONG(30, "RETURNS_SENDWRONG", "商家发错货"),
    RETURNS_INCONFORMITY(31, "RETURNS_INCONFORMITY", "商品描述不符"),
    RETURNS_BUYWRONG(32, "RETURNS_BUYWRONG", "拍错/多拍/不喜欢"),
    RETURNS_QUALITY(33, "RETURNS_QUALITY", "质量问题"),
    RETURNS_FAKE(34, "RETURNS_FAKE", "假货"),
    RETURNS_OTHER(35, "RETURNS_OTHER", "其他"),
    ROUGH_WORKMANSHIP(36, "ROUGH_WORKMANSHIP", "做工粗糙/有瑕疵"),
    NOT_REAL_ORIGIN(37, "NOT_REAL_ORIGIN", "非正品"),
    SEND_GOODS_FAIL_APPOINTMENT_TWO(38, "SEND_GOODS_FAIL_APPOINTMENT_TWO", "未按约定时间发货"),
    RETURN_FREIGHT_TWO(39, "RETURN_FREIGHT_TWO", "退运费"),
    SEVEN_DAY_NO_REASON(40, "SEVEN_DAY_NO_REASON", "7天无理由退货"),
    CASH_BACK_REFUND(41, "CASH_BACK_REFUND", "返现退款"),
    HOTEL_REJECT_ORDER_REFUND(42, "HOTEL_REJECT_ORDER_REFUND", "酒店拒单退款"),
    GROUP_DEDUCT_STOCK_FAILED_REFUND(43, "GROUP_DEDUCT_STOCK_FAILED_REFUND", "拼团订单扣库存失败退款"),
    ORDER_CLOSE_REFUND(44, "ORDER_CLOSE_REFUND", "订单关闭退款"),
    PEER_PAY_EXPIRE_REFUND(45, "PEER_PAY_EXPIRE_REFUND", "代付过期退款"),
    PEER_PAY_OVER_PAY_REFUND(46, "PEER_PAY_OVER_PAY_REFUND", "代付超付退款"),
    CATERING_REJECT_ORDER_REFUND(47, "CATERING_REJECT_ORDER_REFUND", "外卖拒单退款"),
    REGIMENT_NOT_MASS_REFUND(48, "REGIMENT_NOT_MASS_REFUND", "拼团未成团退款"),
    GROUP_CASH_BACK_REFUND(49, "GROUP_CASH_BACK_REFUND", "团购返现退款"),
    MEI_YE_REFUND(50, "MEI_YE_REFUND", "美业退款"),
    LOCK_PAY_REFUND(51, "LOCK_PAY_REFUND", "订单少付退款"),
    WSC_XCX_GROUP_REFUND(52, "WSC_XCX_GROUP_REFUND", "小程序拼团退款"),
    GIVE_GIFT_NOT_RECEIVE_REFUND(53, "GIVE_GIFT_NOT_RECEIVE_REFUND", "送礼子订单未被领取退款"),
    OVERPAY_PRINCIPAL_ALL_REFUND(54, "OVERPAY_PRINCIPAL_ALL_REFUND", "超付+本金组合退款"),
    GIVE_COMMUNITY_EXPIRE_AUTOMATIC_REFUND(55, "GIVE_COMMUNITY_EXPIRE_AUTOMATIC_REFUND", "送礼社群版到期自动退款"),
    COBUILD_ONE_KEY_REFUND(56, "COBUILD_ONE_KEY_REFUND", "上云商家一键退款类型");

    private final int id;
    private final String key;
    private final String desc;

    YzRefundReasonEnum(int id, String key, String desc) {
        this.id = id;
        this.key = key;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<String, YzRefundReasonEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (YzRefundReasonEnum item : YzRefundReasonEnum.values()) {
            CACHE.put(item.key, item);
        }
    }

    public static YzRefundReasonEnum get(String key) {
        return CACHE.get(key);
    }
}
