package cn.kinyun.customer.center.enums.electricity;

import com.kuaike.common.enums.EnumService;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * <a href="https://alidocs.dingtalk.com/spreadsheetv2/d0B4k0MPGuEWlAOV/edit?dentryKey=d0B4k0MPGuEWlAOV&ext=xlsx&docKey=v1GXn4yPv5JDqDQ4&onlineEdit=true&type=s">
 * </>
 * 订单状态映射关系
 */
public enum OrderStatusEnum implements EnumService {

    WAIT_PAY(1, "待支付"),
    HAD_PAY(2, "已支付"),
    WAIT_DELIVERY(3, "待发货"),
    SUCCESSED(4, "已成功"),
    CLOSED(5, "已关闭"),

    PARTIAL_PAY(6, "部分支付"),

    REFUNDED(7, "已退款");

    OrderStatusEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    private final int id;
    private final String name;

    /**
     * 是否收费
     */

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }


    private static final Map<Integer, OrderStatusEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (OrderStatusEnum item : OrderStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static OrderStatusEnum getByEnumName(String enumName) {
        OrderStatusEnum[] values = OrderStatusEnum.values();

        for (OrderStatusEnum value : values) {
            if (StringUtils.equals(value.name(), enumName)) {
                return value;
            }
        }
        return null;
    }

    public static OrderStatusEnum get(int id) {
        return CACHE.get(id);
    }
}
