package cn.kinyun.customer.center.dto.resp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author lanye
 */
@Data
public class OrderSkuResp implements Serializable {

    /**
     * 商户id
     */
    private Long bizId;

    /**
     * 企业id
     */
    private String corpId;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 商品编号
     */
    private String skuNo;

    /**
     * 商品名称
     */
    private String skuName;

    /**
     * 商品封面url
     */
    private String skuImgUrl;

    /**
     * 商品金额
     */
    private Long skuAmount;

    /**
     * 商品备注
     */
    private String remark;

    /**
     * 商品数量
     */
    private Long goodsNum;

    /**
     * 商品购买时间
     */
    private Date paidTime;

    /**
     * 商品来源
     */
    private Integer source;

    /**
     * 是否需要填写收货地址
     */
    private Integer needAddress;

    /**
     * 商品类型 0:scrm商品 1:课程 2:班级 3:课时包
     **/
    private Integer goodsType;

    private List<String> courseFormats; // 课程形式
    private List<String> livePlatforms; // 播放平台

    /**
     * @author lixiaobin
     * @date 2024/5/29 20:37
     */

    @Data
    public static class PayRecordStatisticsResp implements Serializable {
        /**
         * 订单总金额
         **/
        private Long totalOrderAmount;

        /**
         * 订单已付金额
         **/
        private Long totalPayAmount;

        /**
         * 订单应付金额
         */
        private Long totalRemainAmount;
    }
}
