package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AttachAllTag extends BaseReq{

    /**
     * 所有标签
     */
    private List<String> allTagIds;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(customerNum), "customerNum不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(source), "source不能为空");
    }
}
