package cn.kinyun.customer.center.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lanye
 */
@Getter
public enum RefundTypeEnum {
    UNKNOWN(0, "未知"),
    WAY_BACK(1, "原路退回"),
    TRANSFER(2, "转账");


    private int value;
    private String desc;

    RefundTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, RefundTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (RefundTypeEnum item : RefundTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static RefundTypeEnum get(int value) {
        return cache.get(value);
    }

    public static RefundTypeEnum getByDesc(String desc) {
        if (StringUtils.isBlank(desc)) {
            return null;
        }
        for (RefundTypeEnum value : values()) {
            String de = value.getDesc();
            if (StringUtils.equals(de, desc)) {
                return value;
            }
        }
        return null;
    }
}
