package cn.kinyun.customer.center.enums;


import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum ApprovalStatus {
    DEFAULT(0, ""),

    APPROVAL_DOING(1, "待审批"),

    APPROVAL_SUCCESS(2, "审批通过"),

    APPROVAL_REFUSE(3, "审批驳回"),

    APPROVAL_CANCEL(4, "审批撤销");

    private int value;
    private String desc;

    ApprovalStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, ApprovalStatus> cache;

    static {
        cache = new HashMap<>();
        for (ApprovalStatus item : ApprovalStatus.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static ApprovalStatus get(int value) {
        return cache.get(value);
    }
}