package cn.kinyun.customer.center.service;


import cn.kinyun.customer.center.dto.req.ApprovalReq;
import cn.kinyun.customer.center.dto.req.QueryRefundOrderListReq;
import cn.kinyun.customer.center.dto.req.order.RefundOrderReq;
import cn.kinyun.customer.center.dto.resp.*;

import java.util.List;

public interface CcCustomerRefundOrderService {
    /**
     * 添加退款单
     * @param req
     * @return
     */
    String refundOrder(RefundOrderReq req);

    /**
     * 编辑更新退款单
     * @param req
     */
    void updateRefundOrder(RefundOrderReq req);

    /**
     * 重新发起审批
     * @param req
     */
    void approvalAgain(RefundOrderReq req);


    /**
     * 根据订单编号
     * 查询正在退款中退款单
     * @param bizId
     * @param orderNo
     * @return
     */
    String queryRefundByOrderNo(Long bizId, String orderNo);

    /**
     * 根据订单号查询退款单
     * @param bizId
     * @param orderNo
     * @param refundOrderNum
     * @return
     */
    List<RefundOrderResp> queryRefundOrder(Long bizId, String orderNo, String refundOrderNum);

    /**
     * 添加人工转账账号信息
     * @param req
     */
    void transfer(RefundOrderReq req);

    /**
     * 更新审批状态
     * @param spStatus
     */
    void updateRefundOrderSpStatus(Long bizId, Long approvalUser, String refundOrderNum,
                                   Integer spStatus, String remark);


    /**
     * 获取退款单信息
     * @param bizId
     * @param refundNum
     * @return
     */
    RefundOrderInfo getRefundInfoByRefundNum(Long bizId, String refundNum);

    /**
     * 查询退款订单列表
     * @param params
     * @return
     */
    PageRefundOrderListResp refundOrderList(QueryRefundOrderListReq params);


    /**
     * 查询退款统计数据
     * @param params
     * @return
     */
    RefundOrderTotalResp refundOrderTotal(QueryRefundOrderListReq params);


    /**
     * 外部页查询审批人当前待审批状态的退款单信息
     */
    List<RefundOrderListResp> getNeedApprovalRefundOrder(ApprovalReq req);

    /**
     * 更新退款记录
     */
    void setRefundRecord(RefundOrderReq req);
}