package cn.kinyun.customer.center.service;

import cn.kinyun.customer.center.dto.req.*;
import cn.kinyun.customer.center.dto.req.order.*;
import cn.kinyun.customer.center.dto.resp.*;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import com.kuaike.common.sqlbuilder.dto.PageDto;

import java.util.*;

/**
 * desc: 客户订单接口
 *
 * @author yanmaoyuan
 * @date 2021/12/10
 */
@SuppressWarnings("checkstyle:com.puppycrawl.tools.checkstyle.checks.coding.OverloadMethodsDeclarationOrderCheck")
public interface CcCustomerOrderService {

    /**
     * 插入订单
     *
     * @param params
     */
    void addOrder(OrderReq params);

    /**
     * 插入订单支付记录
     *
     * @param params
     */
    void addOrderPayRecord(OrderRecordReq params);


    /**
     * 更新支付状态
     *
     * @param params
     */
    void setOrderPayStatus(SetOrderPayStatusReq params);

    void setOrderStatus(Long bizId, String orderNo, OrderStatusEnum orderStatusEnum);

    /**
     * 更新订单信息
     *
     * @param req
     */
    void setOrder(SetOrderReq req);

    /**
     * 退款信息更新
     *
     * @param params
     */
    void setOrderRefundInfo(SetOrderRefundInfoReq params);

    /**
     * 退款
     *
     * @param params
     */
    void refundOrder(SetOrderRefundInfoReq params);

    /**
     * 查询用户订单信息
     */
    CustomerOrderResp queryCustomerOrderInfo(CustomerInfoPageReq pageReq);

    /**
     * 查询订单列表
     */
    List<CustomerOrderWeworkInfoResp> queryCustomerOrderList(Long bizId, String customerNum);

    /**
     * 查询订单列表
     *
     * @param params
     * @return
     */
    PageOrderListResp orderList(QueryOrderListReq params);

    OrderTotalResp orderCountGroupByUser(QueryOrderListReq params);

    /**
     * 仅仅查询订单信息，不用组装其他数据，
     * @param params
     * @return
     */
    List<OrderListResp> pureQueryOrderList(QueryOrderListReq params);


    OrderTotalResp orderTotal(QueryOrderListReq params);

    List<OrderTotalResp> orderCountList(QueryOrderListReq param);

    /**
     * 查询客户订单列表
     *
     * @param bizId
     * @param customerNums
     * @param pageDto
     * @return
     */
    PageCustomerOrderResp queryByCustomerNum(Long bizId, List<String> customerNums, PageDto pageDto);


    /**
     * 查询订单列表
     *
     * @param bizId
     * @param userId
     * @param skuName
     * @param customerNums
     * @param orderTimeBegin
     * @param orderTimeEnd
     * @param pageDto
     * @return
     */
    PageCustomerOrderResp queryCustomerOrderList(Long bizId, Long userId, String skuName,
                                                 List<String> customerNums, Long orderTimeBegin,
                                                 Long orderTimeEnd, PageDto pageDto);

    /**
     * 统计查询客户数和订单数
     *
     * @param bizId
     * @param userId
     * @param customerNum
     * @param orderTimeBegin
     * @param orderTimeEnd
     * @return
     */
    CustomerAndOrderResp countCustomerAndOrder(Long bizId, Long userId,
                                               List<String> customerNum, Long orderTimeBegin, Long orderTimeEnd);


    /**
     * 查询成单人对应的customerNum
     *
     * @param bizId
     * @param startTime
     * @param endTime
     * @param userIds
     * @param amount
     * @return
     */
    Map<Long, List<String>> countCustomers(Long bizId, Date startTime, Date endTime,
                                           Set<Long> userIds, Long amount);

    /**
     * 根据customerNum 查询客户订单情况
     *
     * @param bizId
     * @param customerNums
     * @return
     */
    List<CustomerOrderAmountResq> sumAmountByCustomerNum(Long bizId, Collection<String> customerNums);

    /**
     * 根据customerNum、userId 查询客户订单情况
     *
     * @param bizId
     * @param userId
     * @param customerNums
     * @return
     */
    List<CustomerOrderAmountResq> sumAmountByUserAndCustomerNum(Long bizId, Long userId, Collection<String> customerNums);


    List<CustomerOrderInfoResp> queryOrderListByUserAndCustomerNums(Long bizId, Long userId, Collection<String> customerNums);

    /**
     * 根据条件统计成交额
     *
     * @param startTime
     * @param endTime
     * @param userIds
     * @param bizId
     * @param amount
     * @return
     */
    Map<Long, Long> countPayAmount(Long bizId, Date startTime, Date endTime,
                                   Set<Long> userIds, Long amount);

    Map<Long, Long> countRefundAmount(RefundReq req);

    /**
     * 手动录入功能
     *
     * @param orderReq
     */
    String addOrderManuel(OrderReq orderReq);


    /**
     * 批量添加功能，目前用于scrm 导入数据
     *
     * @param orderReq
     * @return
     */
    List<String> butchAdd(List<OrderReq> orderReq);

    /**
     * 删除订单
     *
     * @param orderReq
     */
    void delOrder(OrderReq orderReq);

    /**
     * 查看详情
     *
     * @param num
     * @return
     */
    OrderListResp customerOrdDetail(String num);

    /**
     * 校验当前商户订单号是否已存在
     */
    Boolean checkOrderExist(String orderNo);

    /**
     * 批量更新订单成单人成单部门
     *
     */
    void batchUpdate(Long bizId, List<String> orderNos, Long allocUserId, Long allocDeptId);


    /**
     * 更新客户信息
     *
     * @param bizId
     * @param orderNo
     * @param customerNum
     */
    void updateOrderCustomerNum(Long bizId, String orderNo, String customerNum);

    /**
     * 根据商品名称，订单编号，成单人等信息查询客户Id
     **/
    List<String> queryCustomerNumsByOrder(OrderQueryReq req);


    /**
     * 设置订单支付状态为超时未支付
     *
     * @param orderNos
     */
    void setOrderPayTimeoutStatus(List<String> orderNos, List<String> payNos);

    Map<Long, Long> countPayAmountByOrderTime(PayAmountReq req);

    List<OrderStatisticsResp> queryByMobile(Long bizId, Collection<String> mobiles);

    List<String> queryAllOrderCustomers(OrderReq orderReq);

    List<OrderStatisticsResp> queryByCustomerNums(Long bizId, Collection<String> customerNums);

    /**
     * 获取客户的第一个订单简明信息
     *
     * @param bizId 商户id
     * @param customerNum 客户标识集合
     */
    CustomerOrderSimpleInfoResp queryCustomerFirstOrderSimpleInfoByCustomerNums(Long bizId, String customerNum);

    /**
     * 根据时间范围
     * 按需查询订单信息
     */
    List<CustomerOrderInfoResp> queryOrderByTime(Long bizId, Collection<String> customerNum, Collection<PayStatusEnum> payStatusEnums,
                                                 Date orderTimeBegin, Date orderTimeEnd);

    CustomerOrderSimpleInfoResp queryOrderSimpleInfoByOrderNo(Long bizId, String orderNo);

    /**
     * 更新订单的电子合同签署状态
     */
    void updateOrderContractSignStatus(String orderNo, Integer signStatus);

    /**
     * 查找order_sku_list中的 商品列表
     **/
    List<CustomerOrderSkuList> searchOrderSkuList(Long bizId, String skuName);

    Long getOrderRemainPayAmount(Long bizId, String orderNo);

    Long getOrderBizIdByOrderNo(String orderNo);

    void addSaveOrderPeriods(OrderPeriodsReq req);

    TuitionReportRespDto tuitionReportList(TuitionReportReq req);

    void tuitionReportSavePaymentOrder( );

    void tuitionReportSaveRefundOrder( );
}
