package cn.kinyun.customer.center.enums;

import cn.kinyun.customer.center.enums.electricity.PlatformEnum;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * author: jw
 * date: 2022/4/21 上午10:44
 * content: 订单系统来源
 */
public enum OrderSource {
    BJYX_ORDER("bjyx", "网校订单", false, false),
    OPEN_API("API", "API对接", false,false),
    TRADE_ORDER("trade", "商品订单系统", false,false),
    SHOP_ORDER("shop", "小商店订单", false,false),
    AD_ORDER("ad", "广告订单", false,false),
    MEETING_ORDER("meeting", "直播带货订单", false,false),
    ELECTRIC_ORDER("electric", "电商订单", true,false),
    YZ_WX_ORDER("electric_yz_wx", "有赞(微信)", true,true),
    YZ_3RD_ORDER("electric_yz_3rd", "有赞(商家自由)", true,true),
    YZ_BUYER_ORDER("electric_yz_buyer", "有赞(买家版)", true,true),
    YZ_BROWSER_ORDER("electric_yz_browser", "有赞(系统浏览器)", true,true),
    YZ_ALI_ORDER("electric_yz_ali", "有赞(支付宝)", true,true),
    YZ_QQ_ORDER("electric_yz_qq", "有赞(腾讯qq)", true,true),
    YZ_WB_ORDER("electric_yz_wb", "有赞(微博)", true,true),
    YZ_OTH_ORDER("electric_yz_other", "有赞(其他)", true,true),
    DOU_ORDER("electric_dou", "抖店", true,true),
    TAOBAO_ORDER("electric_taobao", "淘宝电商", true,false);

    private static final Map<String, OrderSource> CACHE;

    static {
        CACHE = new HashMap<>();
        for (OrderSource e : values()) {
            CACHE.put(e.value, e);
        }
    }

    public static OrderSource getType(String value) {
        return CACHE.get(value);
    }

    private String value;
    private String desc;
    private Boolean electric;
    private Boolean canBeDecode;

    OrderSource(String value, String desc, boolean electric,Boolean canBeDecode) {
        this.value = value;
        this.desc = desc;
        this.electric = electric;
        this.canBeDecode = canBeDecode;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isElectric() {
        return electric;
    }

    public Boolean getCanBeDecode() {
        return canBeDecode;
    }

    public static List<String> getByPlatform(PlatformEnum platformEnum) {
        if (Objects.isNull(platformEnum)) {
            return Lists.newArrayList();
        }
        List<String> orderSourceList = Lists.newArrayList();
        if (platformEnum.equals(PlatformEnum.YOU_ZAN)) {
            orderSourceList= Arrays.stream(values()).filter(item -> item.getValue().startsWith("electric_yz")).map(OrderSource::getValue).collect(Collectors.toList());
        }
        if (platformEnum.equals(PlatformEnum.DOU_DIAN)) {
            orderSourceList= Arrays.stream(values()).filter(item -> item.getValue().startsWith("electric_dou")).map(OrderSource::getValue).collect(Collectors.toList());

        }
        return orderSourceList;
    }
}
