package cn.kinyun.customer.center.dto.resp;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class TuitionReportDto implements Serializable {

    private Long id;

    @ExcelProperty(value = "年份", index = 0)
    private Integer year;

    @ExcelProperty(value = "月份", index = 1)
    private Integer month;

    @ExcelProperty(value = "收款/退款时间", index = 2)
    @DateTimeFormat(value = "yyyy-MM-dd HH:mm:ss")
    private Date payOrRefundTime;

    @ExcelProperty(value = "数据来源", index = 3)
    private String dataSource;

    @ExcelProperty(value = "类型", index = 4)
    private String businessDataType;

    @ExcelProperty(value = "收款/退款公司", index = 5)
    private String merchantName;

    @ExcelIgnore
    private Long schoolId;
    @ExcelProperty(value = "品牌", index = 6)
    private String schoolName;

    @ExcelProperty(value = "商品编码", index = 7)
    private String skuNo;

    @ExcelProperty(value = "商品名称", index = 8)
    private String skuName;

    @ExcelProperty(value = "课程形式", index = 9)
    private String courseFormat;

    @ExcelProperty(value = "播放平台", index = 10)
    private String livePlatform;

    @ExcelProperty(value = "考试类型", index = 11)
    private String examTypeName;

    @ExcelProperty(value = "具体考试", index = 12)
    private String specificExamName;

    @ExcelProperty(value = "学员编号", index = 13)
    private String customerCode;

    @ExcelProperty(value = "学员姓名", index = 14)
    private String customerName;

    @ExcelProperty(value = "学员电话", index = 15)
    private String customerMobile;

    @ExcelProperty(value = "微信或QQ", index = 16)
    private String qqWechat;

    /**
     * 服务开始时间
     * 下单时间，显示年月日；退款单显示的也是隶属的订单的下单时间
     */
    @ExcelProperty(value = "服务开始时间", index = 17)
    @DateTimeFormat(value = "yyyy-MM-dd")
    private Date serviceBeginTime;


    @ExcelProperty(value = "服务结束时间", index = 18)
    @DateTimeFormat(value = "yyyy-MM-dd")
    private Date serviceEndTime;

    @ExcelProperty(value = "赠送服务结束时间", index = 19)
    @DateTimeFormat(value = "yyyy-MM-dd")
    private Date giftServiceEndTime;

    @ExcelIgnore
    private Date validateDateBegin;
    @ExcelIgnore
    private Date validateDateEnd;
    @ExcelProperty(value = "课程有效期", index = 20)
    private String validateDateStr;

    @ExcelProperty(value = "学员协议", index = 21)
    private String signContractStatus;

    @ExcelProperty(value = "课时使用情况（确认）", index = 22)
    private BigDecimal confirmPeriodsCount;

    @ExcelProperty(value = "课时使用情况（已排）", index = 23)
    private BigDecimal dispatchPeriodsCount;

    @ExcelProperty(value = "课时使用情况（退款）", index = 24)
    private BigDecimal refundPeriodsCount;


    @ExcelProperty(value = "课时使用情况（剩余）", index = 25)
    private BigDecimal surplusPeriodsCount;

    @ExcelProperty(value = "合同签订时的备注信息", index = 26)
    private String signContractRemark;

    @ExcelIgnore
    private Integer isContainPhysical;
    @ExcelProperty(value = "是否含有课程实体教材", index = 27)
    private String isContainPhysicalDesc;

    @ExcelProperty(value = "物流公司", index = 28)
    private String logisticsCompany;

    @ExcelProperty(value = "物流单号", index = 29)
    private String trackingNo;

    @ExcelProperty(value = "收款/退款方式", index = 30)
    private String channelTypeName;

    @ExcelProperty(value = "收款/退款账号", index = 31)
    private String merchantCode;

    @ExcelProperty(value = "交易单号", index = 32)
    private String tradeNo;

    @ExcelProperty(value = "产品报价", index = 33)
    private String orderAmount;

    @ExcelProperty(value = "优惠金额", index = 34)
    private String discountAmount;

    @ExcelProperty(value = "实际收款/退款金额", index = 35)
    private String realAmount;

    @ExcelProperty(value = "退款原因", index = 36)
    private String refundReason;

    @ExcelProperty(value = "退款方式", index = 37)
    private String refundWay;

    @ExcelIgnore
    private Long achieveDepartId;
    @ExcelProperty(value = "业绩归属部门", index = 38)
    private String achieveDepartDesc;

    @ExcelProperty(value = "首咨人", index = 39)
    private String consultantName;

    @ExcelProperty(value = "成单人", index = 40)
    private String userName;

    @ExcelProperty(value = "下单备注信息", index = 41)
    private String orderRemark;

    @ExcelProperty(value = "状态", index = 42)
    private String statusDesc;

    @ExcelIgnore
    private Integer isDeleted;
    @ExcelProperty(value = "是否删除", index = 43)
    private String isDeletedDesc;

    @ExcelIgnore
    private String payGroupKey;
    @ExcelIgnore
    private Integer channelType;
    @ExcelIgnore
    private String refundSerialNo;
    @ExcelIgnore
    private String orderNo;
}
