package cn.kinyun.customer.center.dto.resp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CustomerOrderSimpleInfoResp implements Serializable {

    private Long customerOrderId;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 订单金额
     */
    private Long orderAmount;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 商品编号
     */
    private List<String> skuNos;

    /**
     * 商品名称
     */
    private String skuName;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户手机号
     */
    private String customerPhone;

    /**
     * 客户唯一标识
     */
    private String customerNum;

    /**
     * 订单状态
     * @see cn.kinyun.customer.center.enums.electricity.OrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 订单实际支付金额
     */
    private Long paidAmount;

    /**
     * 优惠金额
     */
    private Long discountAmount;
}
