package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.Objects;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/12/13
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SetBindingReq extends BaseReq {

    /**
     * 逻辑删除状态
     */
    private Integer isDeleted;

    /**
     * 解除绑定的时间
     */
    private Date deleteTime;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(customerNum), "customerNum不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(source), "source不能为空");

        Preconditions.checkArgument(StringUtils.isNotBlank(weworkUserNum) || (Objects.nonNull(userId) && userId > 0L), "weworkUserNum,userId不能同时为空");
        if (StringUtils.isBlank(weworkUserNum)) {
            weworkUserNum = "";
        }
        if (Objects.isNull(userId) || userId <= 0L) {
            userId = -1L;
        }
        if (source.equals("crm")) {
            Preconditions.checkArgument(userId != null, "userId不能为空");
        }
        Preconditions.checkArgument(Objects.nonNull(isDeleted) && isDeleted >= 0 && isDeleted <= 1, "isDeleted is null or not valid");
        if (StringUtils.isBlank(productLineId)) {
            productLineId = "";
        }
    }
}
