package cn.kinyun.customer.center.enums.electricity;

import cn.kinyun.customer.center.enums.RefundStatusEnum;
import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

public enum YzRefundMsgTypeEnum implements EnumService {
    TRADE_REFUND_REFUNDSUCCESS(1, "trade_refund_RefundSuccess", "买家退货成功(终态)", 1, RefundStatusEnum.REFUNDED.getValue()),
    TRADE_REFUND_REFUNDSELLERAGREE(2, "trade_refund_RefundSellerAgree", "卖家同意退款（终态）", 1, RefundStatusEnum.REFUNDED.getValue()),
    TRADE_REFUND_REFUNDSELLERCREATED(3, "trade_refund_RefundSellerCreated", "卖家主动退款", 1, RefundStatusEnum.REFUNDING.getValue()),
    TRADE_REFUND_BUYERCREATED(4, "trade_refund_BuyerCreated", "买家发起退款", 1, RefundStatusEnum.REFUNDING.getValue()),
    TRADE_REFUND_REFUNDSELLERREFUSE(5, "trade_refund_RefundSellerRefuse", "卖家拒绝退款", 1, RefundStatusEnum.FAIL.getValue()),
    TRADE_REFUND_REFUNDCLOSED(6, "trade_refund_RefundClosed", "买家取消退款", 1, RefundStatusEnum.FAIL.getValue()),
    TRADE_REFUND_REFUNDSELLERREFUSEBUYERRETURNGOODS(7, "trade_refund_RefundSellerRefuseBuyerReturnGoods", "卖家拒绝退货", 1, RefundStatusEnum.FAIL.getValue()),
    TRADE_REFUND_REFUNDBUYERRETURNGOODS(8, "trade_refund_RefundBuyerReturnGoods", "买家退货给卖家", 1, RefundStatusEnum.REFUNDING.getValue()),
    TRADE_REFUND_REFUNDSELLERAGREERETURNGOODS(9, "trade_refund_RefundSellerAgreeReturnGoods", "卖家同意退款退货", 1, RefundStatusEnum.REFUNDING.getValue()),
    TRADE_REFUND_SYSREFUND(10, "trade_refund_SysRefund", "一键退款/系统退款", 1, RefundStatusEnum.REFUNDING.getValue()),
    TRADE_REFUND_REFUNDAGAIN(11, "trade_refund_RefundAgain", "买家再次发起退款", 1, RefundStatusEnum.REFUNDING.getValue());

    private final int id;
    private final String type;
    private final String desc;
    //是否收费 0：不收费 1：收费
    private final Integer charge;
    private final Integer refundStatus;

    YzRefundMsgTypeEnum(int id, String type, String desc, Integer charge, Integer refundStatus) {
        this.id = id;
        this.type = type;
        this.desc = desc;
        this.charge = charge;
        this.refundStatus = refundStatus;
    }

    @Override
    public int getValue() {
        return id;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCharge() {
        return charge;
    }

    public Integer getRefundStatus() {
        return refundStatus;
    }

    private static final Map<String, YzRefundMsgTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (YzRefundMsgTypeEnum item : YzRefundMsgTypeEnum.values()) {
            CACHE.put(item.getType(), item);
        }
    }

    public static YzRefundMsgTypeEnum get(String type) {
        return CACHE.get(type);
    }
}
