package cn.kinyun.customer.center.dto.req.operator;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Data
public class CustomerTagQueryReq implements Serializable {

    private Long bizId;

    /**
     * CRM的销售线ID
     */
    private String productLineId;

    /**
     * 用户ID->weworkUserNum
     */
    private Map<Long, String> userId2WeworkUserNumMap;

    /**
     * 选定的标签组和标签
     * [
     *      [               // 标签组1
     *          标签a,
     *          标签b
     *      ],              // 标签组2
     *      [
     *          标签c,
     *          标签d
     *      ]
     * ]
     */
    private List<List<String>> tagGroups;

    public void validate() {
        Preconditions.checkArgument(Objects.nonNull(bizId),"bizId can not be null or empty");
        Preconditions.checkArgument(MapUtils.isNotEmpty(userId2WeworkUserNumMap), "userId2WeworkUserNumMap can not be null or empty");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(tagGroups), "tagGroups can not be null or empty");
    }
}
