package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.util.Collection;
import java.util.Date;

/**
 * @author Created by chenjiaqiang on 2023/08/11
 **/
@Data
public class CustomerAllocAggReq extends BaseReq {

    private Date startTime;

    private Date endTime;

    private Collection<Integer> opList;

    private Collection<String> userNums;

    /**
     * 聚合统计 1分配数据 还是 2释放数据
     */
    private Integer aggType;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
    }
}
