package cn.kinyun.customer.center.service;

import cn.kinyun.customer.center.dto.req.*;

import java.util.List;

/**
 * desc: 客户标签接口
 *
 * @author yanmaoyuan
 * @date 2021/12/10
 */
public interface CcCustomerTagService {

    /**
     * 设置客户标签
     *
     * @param params
     */
    void setTags(SetTagReq params);

    /**
     * 批量设置客户标签
     *
     * @param params
     */
    void batchSetTags(BatchSetTagReq params);

    /**
     * 增量打标签
     *
     * @param params
     */
    void attachTag(AttachTagReq params);

    /**
     * 查询客户标签
     *
     * @param params
     * @return
     */
    List<IdAndNameDto> getTags(SetTagReq params);

    /**
     * 把secondCustomerNum上的标签转移到mainCustomerNum上
     * @param bizId
     * @param mainCustomerNum
     */
    void transferCustomerTag(Long bizId, String mainCustomerNum, List<String> customerNums);

    /**
     *
     *  全量更新某个客户标签
     * */
    void updateAllTag(AttachAllTag params);

}