package cn.kinyun.customer.center.enums;

import com.kuaike.common.enums.EnumService;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Date: 2021/12/20 20:44
 * <p>
 * 客户轨迹类型
 * @Author: dayu
 */
@Getter
public enum CustomerRouteType implements EnumService {

    RADAR(1, "互动雷达"),
    PAY_ORDER(2, "购买订单"),
    DYNAMIC_FORM(3, "动态表单"),
    REFRESH_LEADS(4, "线索刷新"),
    DATA_RELATION(5, "数据互通"),
    LIVE(6, "直播记录"),
    AD(7, "广告投放"),
    MARKETING_PLAN(8, "渠道活码/区域码"),

    LEARNING_ROUTE(16, "学习轨迹")
    ;

    private final int value;

    private final String desc;

    CustomerRouteType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, CustomerRouteType> CACHE;

    static {
        Map<Integer, CustomerRouteType> map = new HashMap<>();
        for (CustomerRouteType e : values()) {
            map.put(e.value, e);
        }
        CACHE = map;
    }

    public static CustomerRouteType getType(Integer value) {
        return CACHE.get(value);
    }
}
