package cn.kinyun.customer.center.utils;


import java.util.Objects;

/**
 * @author louis
 * @date 2022/5/6
 */
@SuppressWarnings("all")
public class PriceUtil {


    public static Long priceToLong(String price) {
       return priceToLong(price, 4);
    }


    public static Long priceToLong(String price, Integer scale) {
        if (Objects.isNull(price) || Objects.isNull(scale)) {
            return Long.valueOf(0);
        }
        double money = 0;
        try {

             money  = Double.parseDouble(price);
        } catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }

        float divisor = getDivisor(scale);

        Double v = money * divisor;
        return v.longValue();

    }

    /**
     *
     * @param price 金额值
     * @param scale 保留位数
     * @return
     */
    public static String priceToStr(Long price, Integer scale) {
        if (Objects.isNull(price) || Objects.isNull(scale)) {
            return String.valueOf(0);
        }
        if (price == 0 || scale == 0) {
            return String.valueOf(price);
        }
        if (price < 0) {
            throw new IllegalArgumentException("金额不能为负数");
        }
        if (scale < 0) {
            throw new IllegalArgumentException("保留的位数不能为为负数");
        }

        float divisor = getDivisor(scale);

        Float realPrice = price / divisor;
        return String.valueOf(realPrice);
    }


    private static float getDivisor(Integer scale) {
        float base = 10F;
        float result = base;
        for (int i = 1; i < scale; i++) {
            result = result * base;
        }
        return result;
    }
}
