package cn.kinyun.customer.center.enums.electricity;

import cn.kinyun.customer.center.enums.PayChannelType;
import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;


/**
 * @author lanye
 * @Description 有赞支付类型枚举类
 * <>支付类型；WEIXIN-微信支付(1); WEIXIN_DAIXIAO-微信代销支付类型，
 * 包含如下支付渠道：[WXPAY_DAIXIAO-微信支付(10);WXPAY_SHOULI-受理模式(11);WX_APPPAY-sdk支付(13);WX_WAPPAY-微信支付(19);
 * WX_HB-微信红包支付(20);BARCODE_WX-微信支付(29);WX_NATIVE-微信支付(72);OF_YOUZAN_QR-收款码(101);OF_WEIXIN-微信(102)]；
 * ALIPAY-支付宝支付类型，包含如下支付渠道：[ALIWAP-支付宝-用户付(2);ALIPAY-支付宝-用户付(3);BARCODE_ALIPAY-支付宝-商家扫(30);
 * ALIPAY_HBFQ-支付宝花呗分期支付(53);OF_ALIPAY-支付宝支付(103);MARK_PAY_ALIPAY-标记支付-支付宝(111);ALIPAY_FLOWER-花呗支付(4095);
 * ALIPAY_AGREEMENT-支付宝免密支付(4096); ALIPAY_APPLET-支付宝-用户付(4097)]； BANKCARDPAY-银行卡支付类型，
 * 包含如下支付渠道：[ UNIONPAY-(4);UNIONWAP-(6);UMPAY-联动优势(8); YZPAY-易宝支付(24);CREDIT_CARD_UNIONPAY-银行卡支付(36);
 * DEBIT_CARD_UNIONPAY-银行卡支付(37); ]； PREPAIDCARD-储值卡支付类型，包含如下支付渠道：[PREPAID_CARD-储值卡支付(25);
 * UNIFIED_PREPAID_CARD-储值卡支付(35);OF_PREPAID_CARD-储值卡(106) ]； ECARD-E卡支付类型，包含如下支付渠道：[ECARD-E卡支付(28);
 * OF_E_CARD-有赞E卡(107)]； MARKPAY-标记支付类型，包含如下支付渠道： [ MARK_PAY_WXPAY-标记支付-微信(110); MARK_PAY_ALIPAY-标记支付-支付宝(111);
 * MARK_PAY_POS-标记支付-自有POS刷卡(112); MARK_PAY_DIY-标记收款-自定义(114); MARK_PAY_CREDIT_PAY-标记支付-挂账(205); ]
 * "ENCHASHMENT_GIFT_CARD-礼品卡支付类型，包含如下支付渠道：[ GIFT_CARD-礼品卡支付(33);ENCHASHMENT_GIFT_CARD-礼品卡支付(90); ],
 * DEFAULT-默认值,未支付(0); TENPAY-财付通(5); PEERPAY-找人代付(7); CODPAY-货到付款(9); BAIDUWAP-银行卡支付(12); FX_MERGED-合并付货款(14);
 * UMP_PRESENT-领取赠品(15); UMP_COUPON-优惠兑换(16); FX_SPLITTING-自动付货款(17); AIXUEDAI-爱学贷(18); UMP_REBATE-返利(21);
 * UMP_HB-ump红包(22); PAYZA-(23); PAYPAL-(26); QQPAY-QQ钱包(27); INSTALMENT-分期支付(40); PRIOR_USE-先用后付(49);
 * UN_SETTLED_AMOUNT_PAY-店铺余额支付(80); OF_ONLINE_ACCOUNT-代收账户(100); OF_POS-刷卡(104); OF_TABLE_CARD-二维码台卡(105);
 * ALLIN_SWIPECARD-POS刷卡(113); CHANGE_PAY-有赞零钱(115); UMP_PAY-优惠全额抵扣(116); SUNMI_WX-商米支付(117); SUNMI_ALIPAY-商米支付-支付宝(118);
 * SUNMI_SWIPECARD-商米pos(119); OF_OFFLINE_ACCOUNT-记账账户(200); OF_CASH-现金支付(201); MIXED_PAYMENT-组合支付(202);
 * OUTSIDE_PAYMENT-外部支付(203); TRANSFER_TO_PUBLIC-对公转账(206); OF_ONLINE_PREPAID_ACCOUNT-储值账户(300);
 * OF_ONLINE_DEPOSIT_ACCOUNT-保证金账户(400); ABC_EPAY-农行商E付(4093); ELECTRONIC_BANK_PAY-银联网银支付(4101);</>
 */
public enum YzPayTypeEnum implements EnumService {

    WEIXIN(1, "WEIXIN", PayChannelType.WEIXIN_APP.getValue()),
    ALIWAP(2, "ALIWAP", PayChannelType.ALIPAY_APP.getValue()),
    ALIPAY(3, "ALIPAY", PayChannelType.ALIPAY_APP.getValue()),
    UNIONPAY(4, "UNIONPAY", PayChannelType.BANKCARD.getValue()),
    TENPAY(5, "TENPAY", PayChannelType.OTHER.getValue()),
    UNIONWAP(6, "UNIONWAP", PayChannelType.BANKCARD.getValue()),
    PEERPAY(7, "PEERPAY", PayChannelType.OTHER.getValue()),
    UMPAY(8, "UMPAY", PayChannelType.BANKCARD.getValue()),
    CODPAY(9, "CODPAY", PayChannelType.OTHER.getValue()),
    WXPAY_DAIXIAO(10, "WXPAY_DAIXIAO", PayChannelType.WEIXIN_APP.getValue()),
    WXPAY_SHOULI(11, "WXPAY_SHOULI", PayChannelType.WEIXIN_APP.getValue()),
    BAIDUWAP(12, "BAIDUWAP", PayChannelType.BANKCARD.getValue()),
    WX_APPPAY(13, "WX_APPPAY", PayChannelType.WEIXIN_APP.getValue()),
    FX_MERGED(14, "FX_MERGED", PayChannelType.OTHER.getValue()),
    UMP_PRESENT(15, "UMP_PRESENT", PayChannelType.OTHER.getValue()),
    UMP_COUPON(16, "UMP_COUPON", PayChannelType.OTHER.getValue()),
    FX_SPLITTING(17, "FX_SPLITTING", PayChannelType.OTHER.getValue()),
    AIXUEDAI(18, "AIXUEDAI", PayChannelType.OTHER.getValue()),
    WX_WAPPAY(19, "WX_WAPPAY", PayChannelType.WEIXIN_APP.getValue()),
    WX_HB(20, "WX_HB", PayChannelType.WEIXIN_APP.getValue()),
    UMP_REBATE(21, "UMP_REBATE", PayChannelType.OTHER.getValue()),
    UMP_HB(22, "UMP_HB", PayChannelType.OTHER.getValue()),
    PAYZA(23, "PAYZA", PayChannelType.OTHER.getValue()),
    YZPAY(24, "YZPAY", PayChannelType.BANKCARD.getValue()),
    PREPAID_CARD(25, "PREPAID_CARD", PayChannelType.PREPAIDCARD.getValue()),
    PAYPAL(26, "PAYPAL", PayChannelType.OTHER.getValue()),
    QQPAY(27, "QQPAY", PayChannelType.OTHER.getValue()),
    ECARD(28, "ECARD", PayChannelType.OTHER.getValue()),
    BARCODE_WX(29, "BARCODE_WX", PayChannelType.WEIXIN_APP.getValue()),
    GIFT_CARD(33, "GIFT_CARD", PayChannelType.GIFT_CARD.getValue()),
    WX_NATIVE(72, "WX_NATIVE", PayChannelType.WEIXIN_APP.getValue()),
    OF_YOUZAN_QR(101, "OF_YOUZAN_QR", PayChannelType.WEIXIN_APP.getValue()),
    OF_WEIXIN(102, "OF_WEIXIN", PayChannelType.WEIXIN_APP.getValue()),
    BARCODE_ALIPAY(30, "BARCODE_ALIPAY", PayChannelType.ALIPAY_APP.getValue()),
    ALIPAY_HBFQ(53, "ALIPAY_HBFQ", PayChannelType.ALIPAY_APP.getValue()),
    OF_ALIPAY(103, "OF_ALIPAY", PayChannelType.ALIPAY_APP.getValue()),
    ALIPAY_FLOWER(4095, "ALIPAY_FLOWER", PayChannelType.ALIPAY_APP.getValue()),
    ALIPAY_AGREEMENT(4096, "ALIPAY_AGREEMENT", PayChannelType.ALIPAY_APP.getValue()),
    ALIPAY_APPLET(4097, "ALIPAY_APPLET", PayChannelType.ALIPAY_APP.getValue()),
    OF_E_CARD(107, "OF_E_CARD", PayChannelType.OTHER.getValue()),
    MARK_PAY_WXPAY(110, "MARK_PAY_WXPAY", PayChannelType.WEIXIN_APP.getValue()),
    MARK_PAY_ALIPAY(111, "MARK_PAY_ALIPAY", PayChannelType.ALIPAY_APP.getValue()),
    MARK_PAY_POS(112, "MARK_PAY_POS", PayChannelType.BANKCARD.getValue()),
    MARK_PAY_DIY(114, "MARK_PAY_DIY", PayChannelType.OTHER.getValue()),
    MARK_PAY_CREDIT_PAY(205, "MARK_PAY_CREDIT_PAY", PayChannelType.OTHER.getValue()),
    CREDIT_CARD_UNIONPAY(36, "CREDIT_CARD_UNIONPAY", PayChannelType.BANKCARD.getValue()),
    DEBIT_CARD_UNIONPAY(37, "DEBIT_CARD_UNIONPAY", PayChannelType.BANKCARD.getValue()),
    UNIFIED_PREPAID_CARD(35, "UNIFIED_PREPAID_CARD", PayChannelType.PREPAIDCARD.getValue()),
    OF_PREPAID_CARD(106, "OF_PREPAID_CARD", PayChannelType.PREPAIDCARD.getValue()),
    ENCHASHMENT_GIFT_CARD(90, "ENCHASHMENT_GIFT_CARD", PayChannelType.GIFT_CARD.getValue()),
    INSTALMENT(40, "INSTALMENT", PayChannelType.OTHER.getValue()),
    PRIOR_USE(49, "PRIOR_USE", PayChannelType.OTHER.getValue()),
    UN_SETTLED_AMOUNT_PAY(80, "UN_SETTLED_AMOUNT_PAY", PayChannelType.OTHER.getValue()),
    OF_ONLINE_ACCOUNT(100, "OF_ONLINE_ACCOUNT", PayChannelType.OTHER.getValue()),
    OF_POS(104, "OF_POS", PayChannelType.OTHER.getValue()),
    OF_TABLE_CARD(105, "OF_TABLE_CARD", PayChannelType.OTHER.getValue()),
    ALLIN_SWIPECARD(113, "ALLIN_SWIPECARD", PayChannelType.OTHER.getValue()),
    CHANGE_PAY(115, "CHANGE_PAY", PayChannelType.OTHER.getValue()),
    UMP_PAY(116, "UMP_PAY", PayChannelType.OTHER.getValue()),
    SUNMI_WX(117, "SUNMI_WX", PayChannelType.OTHER.getValue()),
    SUNMI_ALIPAY(118, "SUNMI_ALIPAY", PayChannelType.OTHER.getValue()),
    SUNMI_SWIPECARD(119, "SUNMI_SWIPECARD", PayChannelType.OTHER.getValue()),
    OF_OFFLINE_ACCOUNT(200, "OF_OFFLINE_ACCOUNT", PayChannelType.OTHER.getValue()),
    OF_CASH(201, "OF_CASH", PayChannelType.UNKNOW.getValue()),
    MIXED_PAYMENT(202, "MIXED_PAYMENT", PayChannelType.OTHER.getValue()),
    OUTSIDE_PAYMENT(203, "OUTSIDE_PAYMENT", PayChannelType.OTHER.getValue()),
    TRANSFER_TO_PUBLIC(206, "TRANSFER_TO_PUBLIC", PayChannelType.OTHER.getValue()),
    OF_ONLINE_PREPAID_ACCOUNT(300, "OF_ONLINE_PREPAID_ACCOUNT", PayChannelType.OTHER.getValue()),
    OF_ONLINE_DEPOSIT_ACCOUNT(400, "OF_ONLINE_DEPOSIT_ACCOUNT", PayChannelType.OTHER.getValue()),
    ABC_EPAY(4093, "ABC_EPAY", PayChannelType.OTHER.getValue()),
    ELECTRONIC_BANK_PAY(4101, "ELECTRONIC_BANK_PAY", PayChannelType.OTHER.getValue()),
    UNKNOWN(9999, "unknown", PayChannelType.OTHER.getValue());

    private final int id;
    private final String desc;
    private final Integer payChannelType;

    YzPayTypeEnum(int id, String desc, Integer payChannelType) {
        this.id = id;
        this.desc = desc;
        this.payChannelType = payChannelType;
    }

    @Override
    public int getValue() {
        return id;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getPayChannelType() {
        return payChannelType;
    }

    private static final Map<Integer, YzPayTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (YzPayTypeEnum item : YzPayTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static YzPayTypeEnum get(Integer type) {
        YzPayTypeEnum yzPayTypeEnum = CACHE.get(type);
        if (yzPayTypeEnum == null) {
            return UNKNOWN;
        }
        return yzPayTypeEnum;
    }
}