package cn.kinyun.customer.center.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * author: jw
 * date: 2022/1/25 下午2:40
 * content:
 */
public enum VisitorType {
    OFFICIAL(1, "公众号"),

    WEWORK(2, "企业微信"),

    MINI_PROGRAM(3, "小程序"),

    UNKNOWN(4, "未知")
    ;


    private int value;
    private String desc;

    VisitorType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, VisitorType> CACHE;


    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    static {
        CACHE = new HashMap<>();
        for (VisitorType item : VisitorType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static VisitorType get(int value) {
        return CACHE.get(value);
    }
}
