package cn.kinyun.customer.center.service;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.dto.resp.CustomerMobileNumResp;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * desc: 客户标识接口
 *
 * @author yanmaoyuan
 * @date 2021/12/9
 */
@SuppressWarnings("checkstyle:com.puppycrawl.tools.checkstyle.checks.coding.OverloadMethodsDeclarationOrderCheck")
public interface CcCustomerNumService {

    /**
     * 根据type、id1、id2获取客户唯一编号
     *
     * @param bizId   商户ID
     * @param type    客户标识类型
     * @param id1     标识1
     * @param id2     标识2
     * @param unionId unionId
     * @see cn.kinyun.customer.center.enums.CustomerIdType
     */
    String getCustomerNumByType(Long bizId, int type, String id1, String id2, String unionId);

    // 根据手机号获取customerNum
    Map<String, String> batchGetCustomerNumByMobile(Long bizId, Collection<String> mobiles);

    /**
     * 批量查询有contactId 的手机号
     * @param bizId
     * @param mobiles
     * @return
     */
    Map<String, String> batchGetContactCustomerNumByMobile(Long bizId, Collection<String> mobiles);

    /**
     * 通过手机号查询互通contact_id
     * @param bizId
     * @param mobiles
     * @return
     */
    Map<String, List<String>> batchGetContactIdByMobile(Long bizId, Collection<String> mobiles);

    // 根据手机号获取customerNum
    String getCustomerNumByMobile(Long bizId, String mobile);

    String getContactCustomerNumByMobile(Long bizId, String mobile);

    // 根据企业客户ID获取customerNum
    String getCustomerNumByWeworkContactId(Long bizId, String contactId, String unionId);// unionId 选填

    // 根据公众号粉丝获取customerNum
    String getCustomerNumByOfficialFans(Long bizId, String appId, String openId, String unionId);// unionId 选填

    // 根据小程序获取customerNum
    String getCustomerNumByMiniProgram(Long bizId, String appId, String openId, String unionId);// unionId 选填

    // 根据H5页面的cookie获取customerNum
    String getCustomerNumByH5Cookie(Long bizId, String cookie);

    // 根据企业微信授权得到的openId获取customerNum
    String getCustomerNumByWeworkOpenId(Long bizId, String openId);

    String getWeworkContactId(Long bizId, String customerNum);

    Map<String, String> getWeworkContactId(Long bizId, Collection<String> customerNums);

    Map<String, String> getOfficialAppId(Long bizId, Collection<String> customerNums);

    Map<String, String> getMiniAppId(Long bizId, Collection<String> customerNums);

    List<String> getMiniAppId(Long bizId, String customerNum);

    List<String> getOfficialAppId(Long bizId, String customerNum);

    List<String> getUnionIds(Long bizId, String customerNum);

    Map<String, List<String>> getUnionIds(Long bizId, Collection<String> customerNums);

    List<String> getMobileByUnionId(Long bizId, String unionId, Integer idType);

    //////////////// 查询已经绑定的客户

    List<String> getCustomerNumsByType(Long bizId, int type, String id1, String id2, String unionId);

    // 根据手机号获取customerNum
    List<String> getCustomerNumsByMobile(Long bizId, String mobile);

    // 根据企业客户ID获取customerNum
    List<String> getCustomerNumsByWeworkContactId(Long bizId, String contactId, String unionId);// unionId 选填

    Map<String, String> butchGetCustomerNumByContactId(Long bizId, Collection<String> contactId);

    // 根据公众号粉丝获取customerNum
    List<String> getCustomerNumsByOfficialFans(Long bizId, String appId, String openId, String unionId);// unionId 选填

    // 根据小程序获取customerNum
    List<String> getCustomerNumsByMiniProgram(Long bizId, String appId, String openId, String unionId);// unionId 选填

    // 根据H5页面的cookie获取customerNum
    List<String> getCustomerNumsByH5Cookie(Long bizId, String cookie);

    // 根据企业微信授权的OpenId获取customerNum
    List<String> getCustomerNumsByWeworkOpenId(Long bizId, String openId);

    /////////////// 绑定客户

    // 绑定企业客户ID和手机号
    boolean bindWeworkContactAndMobile(Long bizId, String contactId, String mobile, String moduleType);

    /**
     * 绑定关系变更，触发同步标识
     *
     * @param bizId
     * @param customerNum
     * @param type
     * @return
     */
    void touchSyncIsAssociate(Long bizId, String customerNum, Integer type);

    // 绑定小程序和手机号
    boolean bindMiniProgramAndMobile(Long bizId, String appId, String openId, String mobile);

    // 绑定公众号和手机号
    boolean bindOfficialAccountAndMobile(Long bizId, String appId, String openId, String mobile, String unionId);

    // 绑定小程序和手机号
    boolean bindAppletAccountAndMobile(Long bizId, String appId, String openId, String mobile, String unionId);

    // 绑定小商店账号和手机号
    boolean bindAccountAndMobile(Long bizId, String account, String mobile);

    boolean bindContactIdAndOpenId(Long bizId, String contactId, String openId, String moduleType);

    // 判断手机号是否存在
    boolean mobileIsExist(Long bizId, String mobile);

    // 判断appId和openId是否存在
    boolean appIdAndOpenIdIsExistByMiniProgram(Long bizId, String appId, String openId, String unionId);// unionId 选填

    // 通过mobile判断用户是否绑定了微信公众号
    boolean mobileBindOfficialAccount(Long bizId, String mobile);

    // 通过mobile判断用户是否绑定了微信小程序
    boolean mobileBindAppletAccount(Long bizId, String mobile);

    /**
     * @param bizId
     * @param mobile1
     * @param mobile2
     * @param moduleType
     * @return
     */
    boolean bindMobile1AndMobile2(Long bizId, String mobile1, String mobile2, String moduleType);

    /**
     * 所有的customerNum
     *
     * @param bizId
     * @param customerNum
     * @return
     */
    List<String> getCustomerNums(Long bizId, String customerNum);

    /**
     * getMainNum
     *
     * @param bizId
     * @param customerNum
     * @return
     */
    String getMainNum(Long bizId, String customerNum);

    /**
     * 线索的customerNum
     *
     * @param bizId
     * @param customerNum
     * @return
     */
    List<String> getLeadsCustomerNum(Long bizId, String customerNum);

    /**
     * 根据企业客户Id（weworkContactId）查询手机号，返回最新一条
     **/
    String getMobileByContactId(Long bizId, String contactId);

    /**
     * 根据企业客户Id（weworkContactId）查询手机号，返回的是list
     **/
    List<String> getMobilesByContactId(Long bizId, String contactId);

    /**
     * 根据customerNums 获取手机号
     *
     * @param bizId
     * @param customerNums
     * @return
     */
    Map<String, String> getMobileByCustomerNums(Long bizId, Collection<String> customerNums);

    CustomerDetailResp getCustomerDetailByType(Long bizId, String contactId);


    void updateCustomerMobile(Long bizId, String customerNum, String mobile1, String mobile2);


    /**
     * 解绑关联关系
     * @param bizId
     * @param customerNum
     */
    void unbind(Long bizId, String customerNum);

    /**
     * 根据企业客户Id（weworkContactId）查询手机号和num，返回的是list
     **/
    List<CustomerMobileNumResp> getMobileNumByContactId(Long bizId, String contactId);


    /**
     * 根据customerNum 获取mainCustomerNum 映射
     * @return
     */
    Map<String, String> getMainNumByCustomerNum(Long bizId, Collection<String> customerNums);

}
