package cn.kinyun.customer.center.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Created by chenjiaqiang on 2021/12/20
 **/
public enum PayChannelType {
    UNKNOW(0, "现金支付", "cash"),
    WEIXIN_NATIVE(1, "微信扫码支付", "weixin"),
    WEIXIN_APP(2, "微信APP支付", "weixin"),
    WEIXIN_H5(3, "微信手机网站支付", "weixin"),
    WEIXIN_JSAPI(4, "微信公众号支付", "weixin"),
    WEIXIN_WEAPPLET(5, "微信小程序支付", "weixin"),
    WEIXIN_PRE_CREATE(6, "微信当面付", "weixin"),
    ALIPAY_PRE_CREATE(7, "支付宝当面付-扫码支付", "alipay"),
    ALIPAY_APP(8, "支付宝APP支付", "alipay"),
    ALIPAY_WAP(9, "支付宝手机网站支付", "alipay"),
    ALIPAY_PAGE(10, "支付宝电脑网站支付", "alipay"),
    BANKCARD(11, "银行卡支付", "bankcard"),
    PREPAIDCARD(12, "储值卡支付", "prepaidcard"),
    GIFT_CARD(13, "礼品卡支付", "giftcard"),
    OTHER(99, "其他", "other");

    private static final Map<Integer, PayChannelType> MAP = Arrays.stream(values()).collect(Collectors.toMap(PayChannelType::getValue, e -> e));
    private final Integer value;
    private final String desc;
    private final String serviceCode;

    PayChannelType(Integer value, String desc, String serviceCode) {
        this.value = value;
        this.desc = desc;
        this.serviceCode = serviceCode;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public static PayChannelType get(Integer value) {
        return MAP.get(value);
    }

    public static PayChannelType getByDesc(String desc) {
        if (StringUtils.isBlank(desc)) {
            return null;
        }
        for (PayChannelType payChannelType : values()) {
            String de = payChannelType.getDesc();
            if (StringUtils.equals(de, desc)) {
                return payChannelType;
            }
        }
        return null;
    }
}
