package cn.kinyun.customer.center.dto.req.order;

import cn.kinyun.customer.center.dto.req.BaseReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * @author Created by chenjiaqiang on 2021/12/13
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SetOrderRefundInfoReq extends BaseReq {

    private String num;
    // 订单编号
    private String orderNo;

    // 退款单号
    private String refundNo;

    // 退款金额
    private Long refundAmount;

    // 退款状态
    private Integer refundStatus;

    /**
     * 退款类型,跟平台类型有关
     *
     * @see cn.kinyun.customer.center.enums.electricity.YzRefundTypeEnum
     */
    private Integer refundType;

    private Integer auditStatus;

    private Date refundTime;

    private String reason;

    private String remark;

    private Long createBy;

    /**
     * 退款关联的订单明细信息
     */
    private String oid;

    /**
     * 平台类型
     *
     * @see cn.kinyun.customer.center.enums.electricity.PlatformEnum
     */
    private Integer platformType;

    /**
     * 退款流水号
     */
    private String refundSerialNo;

    /**
     * 退款方式
     */
    private String refundWay;

    private Integer isDeleted = 0;

    private Integer entry = 0;

    private String refundFailReason;

}
