package cn.kinyun.customer.center.dto.req;


import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/12/13
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SetStageReq extends BaseReq {

    // 阶段ID
    private Long stageId;

    // 阶段备注
    private String remark;

    private Integer status;

    private Long finalStageId;

    private String stageReason;

    private Long stageReasonId;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(customerNum), "customerNum不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(source), "source不能为空");
        stageId = Optional.ofNullable(stageId).orElse(0L);
    }
}
