package cn.kinyun.customer.center.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class ApprovalMsgDto implements Serializable {
    private Long bizId;

    //退款单编号
    private String refundNum;

    //对外关联的编号
    private String refundOrderNo;

    private String orderNo;

    //退款类型 1 原路退回  2 人工转账
    private Integer refundType;

    /**
     * 转账类型是直接转账还是修改之前转账账号
     * true 表示更新转账账号
     * false 表示直接转账
     */
    private Boolean updateTransferAccount;

    //默认是支付宝转账
    private String transferType = "alipayTransfer";

    //退款金额
    private Long refundAmount;

    private String accountName;

    private String account;

    //审批人， 不需要审批的时候为空
    private  Long approvalUserId;

    private String refundReason;

    private Integer approvalStatus;

    //操作人id
    private Long opUserId;

    /**
     * 审批消息生成时间戳
     */
    private long msgTimestamp;
}
