/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.enums.electricity;

import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import com.google.common.collect.Lists;
import com.kuaike.common.enums.EnumService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public enum TaoBaoOrderStatusEnum implements EnumService
{
    WAIT_BUYER_PAY(1, "\u7b49\u5f85\u4e70\u5bb6\u4ed8\u6b3e", "\u7b49\u5f85\u4e70\u5bb6\u4ed8\u6b3e", OrderStatusEnum.WAIT_PAY.getValue()),
    WAIT_PRE_AUTH_CONFIRM(2, "\u4f59\u989d\u5b9d0\u5143\u8d2d\u5408\u7ea6\u4e2d", "\u4f59\u989d\u5b9d0\u5143\u8d2d\u5408\u7ea6\u4e2d", OrderStatusEnum.WAIT_PAY.getValue()),
    PAY_PENDING(3, "\u5916\u5361\u652f\u4ed8\u4ed8\u6b3e\u786e\u8ba4\u4e2d", "\u5916\u5361\u652f\u4ed8\u4ed8\u6b3e\u786e\u8ba4\u4e2d", OrderStatusEnum.WAIT_PAY.getValue()),
    ALL_WAIT_PAY(4, "\u6240\u6709\u4e70\u5bb6\u672a\u4ed8\u6b3e\u7684\u4ea4\u6613", "\u6240\u6709\u4e70\u5bb6\u672a\u4ed8\u6b3e\u7684\u4ea4\u6613", OrderStatusEnum.WAIT_PAY.getValue()),
    TRADE_NO_CREATE_PAY(5, "\u6ca1\u6709\u521b\u5efa\u5916\u90e8\u4ea4\u6613\uff08\u652f\u4ed8\u5b9d\u4ea4\u6613\uff09", "\u6ca1\u6709\u521b\u5efa\u652f\u4ed8\u5b9d\u4ea4\u6613", OrderStatusEnum.WAIT_PAY.getValue()),
    WAIT_SELLER_SEND_GOODS(6, "\u7b49\u5f85\u5356\u5bb6\u53d1\u8d27", "\u7b49\u5f85\u5356\u5bb6\u53d1\u8d27,\u5373:\u4e70\u5bb6\u5df2\u4ed8\u6b3e", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    PAID_FORBID_CONSIGN(7, "\u8be5\u72b6\u6001\u4ee3\u8868\u8ba2\u5355\u5df2\u4ed8\u6b3e\u4f46\u662f\u5904\u4e8e\u7981\u6b62\u53d1\u8d27\u72b6\u6001", "", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    SELLER_CONSIGNED_PART(8, "\u5356\u5bb6\u90e8\u5206\u53d1\u8d27", "\u5356\u5bb6\u90e8\u5206\u53d1\u8d27", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    WAIT_BUYER_CONFIRM_GOODS(9, "\u7b49\u5f85\u4e70\u5bb6\u786e\u8ba4\u6536\u8d27", "\u7b49\u5f85\u4e70\u5bb6\u786e\u8ba4\u6536\u8d27,\u5373:\u5356\u5bb6\u5df2\u53d1\u8d27", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    TRADE_BUYER_SIGNED(10, "\u4e70\u5bb6\u5df2\u7b7e\u6536\uff08\u8d27\u5230\u4ed8\u6b3e\u4e13\u7528\uff09", "\u4e70\u5bb6\u5df2\u7b7e\u6536\uff08\u8d27\u5230\u4ed8\u6b3e\u4e13\u7528\uff09", OrderStatusEnum.SUCCESSED.getValue()),
    TRADE_FINISHED(11, "\u4ea4\u6613\u6210\u529f", "\u4ea4\u6613\u6210\u529f", OrderStatusEnum.SUCCESSED.getValue()),
    TRADE_CLOSED(12, "\u4ea4\u6613\u5173\u95ed", "\u4ed8\u6b3e\u4ee5\u540e\u7528\u6237\u9000\u6b3e\u6210\u529f\uff0c\u4ea4\u6613\u81ea\u52a8\u5173\u95ed", OrderStatusEnum.CLOSED.getValue()),
    TRADE_CLOSED_BY_TAOBAO(13, "\u4ea4\u6613\u88ab\u6dd8\u5b9d\u5173\u95ed", "\u4ed8\u6b3e\u4ee5\u524d\uff0c\u5356\u5bb6\u6216\u4e70\u5bb6\u4e3b\u52a8\u5173\u95ed\u4ea4\u6613", OrderStatusEnum.CLOSED.getValue()),
    ALL_CLOSED(14, "\u6240\u6709\u5173\u95ed\u7684\u4ea4\u6613", "\u6240\u6709\u5173\u95ed\u7684\u4ea4\u6613", OrderStatusEnum.CLOSED.getValue());

    private final int id;
    private final String name;
    private final String desc;
    private final int orderStatus;
    private static final Map<Integer, TaoBaoOrderStatusEnum> CACHE;
    private static final Map<Integer, List<Integer>> statusCache;

    private TaoBaoOrderStatusEnum(int id, String name, String desc, int orderStatus) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.orderStatus = orderStatus;
    }

    public int getValue() {
        return this.id;
    }

    public String getDesc() {
        return this.desc;
    }

    public static List<Integer> getTaoBaoOrderStatus(Integer id) {
        return statusCache.get(id);
    }

    public static TaoBaoOrderStatusEnum getByEnumName(String enumName) {
        TaoBaoOrderStatusEnum[] values;
        for (TaoBaoOrderStatusEnum value : values = TaoBaoOrderStatusEnum.values()) {
            if (!StringUtils.equals((CharSequence)value.name(), (CharSequence)enumName)) continue;
            return value;
        }
        return null;
    }

    public static TaoBaoOrderStatusEnum get(int id) {
        return CACHE.get(id);
    }

    public static List<Integer> getPaidStatus() {
        ArrayList statusList = Lists.newArrayList();
        List<Integer> hadPayList = TaoBaoOrderStatusEnum.getTaoBaoOrderStatus(OrderStatusEnum.HAD_PAY.getValue());
        List<Integer> waitList = TaoBaoOrderStatusEnum.getTaoBaoOrderStatus(OrderStatusEnum.WAIT_DELIVERY.getValue());
        List<Integer> successList = TaoBaoOrderStatusEnum.getTaoBaoOrderStatus(OrderStatusEnum.SUCCESSED.getValue());
        if (CollectionUtils.isNotEmpty(hadPayList)) {
            statusList.addAll(hadPayList);
        }
        if (CollectionUtils.isNotEmpty(waitList)) {
            statusList.addAll(waitList);
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            statusList.addAll(successList);
        }
        return statusList;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getOrderStatus() {
        return this.orderStatus;
    }

    static {
        CACHE = new HashMap<Integer, TaoBaoOrderStatusEnum>(3);
        for (TaoBaoOrderStatusEnum item : TaoBaoOrderStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
        statusCache = new HashMap<Integer, List<Integer>>();
        for (TaoBaoOrderStatusEnum item : TaoBaoOrderStatusEnum.values()) {
            List<Integer> statusList = statusCache.getOrDefault(item.getOrderStatus(), Lists.newArrayList());
            statusList.add(item.getValue());
            statusCache.put(item.getOrderStatus(), statusList);
        }
    }
}

