package cn.kinyun.customer.center.enums.electricity;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;


/**
 * @author sunwen
 * @Description: 订购状态枚举
 */
public enum SubscribeStatusEnum implements EnumService {


    UNSUBSCRIBE(0, "未订购"),
    SUBSCRIBED(1, "已订购"),
    CANCELED_SUBSCRIBE(2, "取消订购");

    private final int id;
    private final String name;

    SubscribeStatusEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, SubscribeStatusEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (SubscribeStatusEnum item : SubscribeStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SubscribeStatusEnum get(int id) {
        return CACHE.get(id);
    }
}