/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.common.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.kuaike.scrm.vip.dto.enums.SystemParamName;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.TransportMode;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
public class CacheConfig
extends CachingConfigurerSupport {
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private Integer port;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.database}")
    private Integer database;
    @Value(value="${spring.redis.pool.max-idle}")
    private Integer maxIdle;
    @Value(value="${spring.redis.pool.min-idle}")
    private Integer minIdle;
    @Value(value="${spring.redis.pool.max-active}")
    private Integer maxActive;
    @Value(value="${spring.redis.pool.max-wait}")
    private Integer maxWait;
    @Value(value="${spring.redis.timeout}")
    private Long timeout;
    @Value(value="${redisson.idleConnectionTimeout:10000}")
    private Integer idleConnectionTimeout;
    @Value(value="redis://${spring.redis.host}:${spring.redis.port}")
    private String address;
    @Value(value="${redisson.connectionMinimumIdleSize:32}")
    private Integer connectionMinimumIdleSize;
    @Value(value="${redisson.connectionPoolSize:64}")
    private Integer connectionPoolSize;
    @Value(value="${redisson.clientName:scrm}")
    private String clientName;
    @Value(value="${redisson.connectTimeout:10000}")
    private Integer connectTimeout;
    @Value(value="${redisson.retryAttempts:3}")
    private Integer retryAttempts;
    @Value(value="${redisson.retryInterval:1500}")
    private Integer retryInterval;
    @Value(value="${redisson.subscriptionsPerConnection:10}")
    private Integer subscriptionsPerConnection;
    @Value(value="${redisson.subscriptionConnectionPoolSize:50}")
    private Integer subscriptionConnectionPoolSize;
    @Value(value="${redisson.subscriptionConnectionMinimumIdleSize:1}")
    private Integer subscriptionConnectionMinimumIdleSize;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    private static final Map<String, String> defaultConfigMap = Maps.newHashMap();
    @Value(value="${minAddFriendsInterval:10}")
    private String minAddFriendsInterval;
    @Value(value="${maxAddFriendsInterval:20}")
    private String maxAddFriendsInterval;
    @Value(value="${everyDayAddFriendsUpperLimit:300}")
    private String everyDayAddFriendsUpperLimit;
    @Value(value="${minPassiveAddFriendsInterval:10}")
    private String minPassiveAddFriendsInterval;
    @Value(value="${maxPassiveAddFriendsInterval:20}")
    private String maxPassiveAddFriendsInterval;
    @Value(value="${everydayPassiveAddFriendsUpperLimit:300}")
    private String everydayPassiveAddFriendsUpperLimit;
    @Value(value="${everydayGroupSendRoomNumUpperLimit:300}")
    private String everydayGroupSendRoomNumUpperLimit;
    @Value(value="${everydayGroupSendWeworkNumUpperLimit:300}")
    private String everydayGroupSendWeworkNumUpperLimit;
    @Value(value="${minGroupSendMessageInterval:10}")
    private String minGroupSendMessageInterval;
    @Value(value="${maxGroupSendMessageInterval:20}")
    private String maxGroupSendMessageInterval;
    @Value(value="${everydayCreateRoomNumUpperLimit:300}")
    private String everydayCreateRoomNumUpperLimit;
    @Value(value="${minCreateRoomInterval:10}")
    private String minCreateRoomInterval;
    @Value(value="${maxCreateRoomInterval:20}")
    private String maxCreateRoomInterval;
    @Value(value="${systemRestEnabled:1}")
    private String systemRestEnabled;
    @Value(value="${minSystemRestTime:22:00}")
    private String minSystemRestTime;
    @Value(value="${maxSystemRestTime:24:00}")
    private String maxSystemRestTime;

    @Primary
    @Bean
    public LettuceConnectionFactory redisConnectionFactory() {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(this.maxIdle.intValue());
        genericObjectPoolConfig.setMinIdle(this.minIdle.intValue());
        genericObjectPoolConfig.setMaxTotal(this.maxActive.intValue());
        genericObjectPoolConfig.setMaxWaitMillis((long)this.maxWait.intValue());
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(200L);
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setDatabase(this.database.intValue());
        redisStandaloneConfiguration.setHostName(this.host);
        redisStandaloneConfiguration.setPort(this.port.intValue());
        redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.password));
        LettucePoolingClientConfiguration clientConfig = LettucePoolingClientConfiguration.builder().commandTimeout(Duration.ofMillis(this.timeout)).poolConfig(genericObjectPoolConfig).build();
        return new LettuceConnectionFactory(redisStandaloneConfiguration, (LettuceClientConfiguration)clientConfig);
    }

    @Primary
    @Bean(destroyMethod="shutdown")
    public RedissonClient redissonClient() {
        Config config = new Config();
        config.setCodec((Codec)new JsonJacksonCodec());
        config.setTransportMode(TransportMode.NIO);
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setIdleConnectionTimeout(this.idleConnectionTimeout.intValue());
        singleServerConfig.setTimeout(this.timeout.intValue());
        singleServerConfig.setAddress(this.address);
        singleServerConfig.setConnectionMinimumIdleSize(this.connectionMinimumIdleSize.intValue());
        singleServerConfig.setConnectionPoolSize(this.connectionPoolSize.intValue());
        singleServerConfig.setDatabase(this.database.intValue());
        singleServerConfig.setClientName(this.clientName);
        singleServerConfig.setPassword(this.password);
        singleServerConfig.setConnectTimeout(this.connectTimeout.intValue());
        singleServerConfig.setRetryAttempts(this.retryAttempts.intValue());
        singleServerConfig.setRetryInterval(this.retryInterval.intValue());
        singleServerConfig.setSubscriptionsPerConnection(this.subscriptionsPerConnection.intValue());
        singleServerConfig.setSubscriptionConnectionPoolSize(this.subscriptionConnectionPoolSize.intValue());
        singleServerConfig.setSubscriptionConnectionMinimumIdleSize(this.subscriptionConnectionMinimumIdleSize.intValue());
        return Redisson.create((Config)config);
    }

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(5L))).transactionAware().build();
    }

    @Primary
    @Bean
    public RedisTemplate<String, String> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate(redisConnectionFactory);
        this.setSerializer(template);
        template.afterPropertiesSet();
        return template;
    }

    @Bean(value={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(LettuceConnectionFactory factory) {
        factory.setShareNativeConnection(false);
        StringRedisTemplate template = new StringRedisTemplate((RedisConnectionFactory)factory);
        template.afterPropertiesSet();
        return template;
    }

    @Primary
    @Bean
    public RedisTemplate<String, Object> objectRedisTemplate(LettuceConnectionFactory factory) {
        factory.setShareNativeConnection(false);
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)factory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        return redisTemplate;
    }

    private void setSerializer(StringRedisTemplate template) {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        om.setDateFormat((DateFormat)simpleDateFormat);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
    }

    @Bean
    public String getGroupSendTaskKey() {
        return this.redisKeyPrefix + "groupSendTaskKey";
    }

    @Bean
    public String getNoticeSendTaskKey() {
        return this.redisKeyPrefix + "noticeSendTaskKey";
    }

    @Bean(value={"defaultMap"})
    public Map<String, String> defaultSystemConfig() {
        defaultConfigMap.put(SystemParamName.MIN_ADD_FRIENDS_INTERVAL.getKey(), this.minAddFriendsInterval);
        defaultConfigMap.put(SystemParamName.MAX_ADD_FRIENDS_INTERVAL.getKey(), this.maxAddFriendsInterval);
        defaultConfigMap.put(SystemParamName.EVERY_DAY_ADD_FRIENDS_UPPER_LIMIT.getKey(), this.everyDayAddFriendsUpperLimit);
        defaultConfigMap.put(SystemParamName.MIN_PASSIVE_ADD_FRIENDS_INTERVAL.getKey(), this.minPassiveAddFriendsInterval);
        defaultConfigMap.put(SystemParamName.MAX_PASSIVE_ADD_FRIENDS_INTERVAL.getKey(), this.maxPassiveAddFriendsInterval);
        defaultConfigMap.put(SystemParamName.EVERYDAY_PASSIVE_ADD_FRIENDS_UPPER_LIMIT.getKey(), this.everydayPassiveAddFriendsUpperLimit);
        defaultConfigMap.put(SystemParamName.EVERYDAY_GROUP_SEND_ROOM_NUM_UPPER_LIMIT.getKey(), this.everydayGroupSendRoomNumUpperLimit);
        defaultConfigMap.put(SystemParamName.EVERYDAY_GROUP_SEND_WEWORK_NUM_UPPER_LIMIT.getKey(), this.everydayGroupSendWeworkNumUpperLimit);
        defaultConfigMap.put(SystemParamName.MIN_GROUP_SEND_MESSAGE_INTERVAL.getKey(), this.minGroupSendMessageInterval);
        defaultConfigMap.put(SystemParamName.MAX_GROUP_SEND_MESSAGE_INTERVAL.getKey(), this.maxGroupSendMessageInterval);
        defaultConfigMap.put(SystemParamName.EVERYDAY_CREATE_ROOM_NUM_UPPER_LIMIT.getKey(), this.everydayCreateRoomNumUpperLimit);
        defaultConfigMap.put(SystemParamName.MIN_CREATE_ROOM_INTERVAL.getKey(), this.minCreateRoomInterval);
        defaultConfigMap.put(SystemParamName.MAX_CREATE_ROOM_INTERVAL.getKey(), this.maxCreateRoomInterval);
        defaultConfigMap.put(SystemParamName.SYSTEM_REST_ENABLED.getKey(), this.systemRestEnabled);
        defaultConfigMap.put(SystemParamName.MIN_SYSTEM_REST_TIME.getKey(), this.minSystemRestTime);
        defaultConfigMap.put(SystemParamName.MAX_SYSTEM_REST_TIME.getKey(), this.maxSystemRestTime);
        return defaultConfigMap;
    }
}

