/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.impl;

import cn.kinyun.crm.common.dto.conf.AllocRuleDefault;
import cn.kinyun.crm.common.dto.conf.FollowActionConf;
import cn.kinyun.crm.common.dto.conf.GuideConf;
import cn.kinyun.crm.common.dto.conf.MobileEncryConf;
import cn.kinyun.crm.common.dto.conf.MultiFollowConf;
import cn.kinyun.crm.common.dto.conf.NoRepeatFieldConf;
import cn.kinyun.crm.common.dto.conf.NoRepeatFieldListConf;
import cn.kinyun.crm.common.dto.conf.OrderAmountConf;
import cn.kinyun.crm.common.dto.conf.ProductLineDto;
import cn.kinyun.crm.common.dto.conf.ReleaseConf;
import cn.kinyun.crm.common.dto.conf.SalesAreaSwitch;
import cn.kinyun.crm.common.dto.conf.SalesModelConf;
import cn.kinyun.crm.common.dto.conf.ShuffleRuleDefault;
import cn.kinyun.crm.common.enums.AllocMode;
import cn.kinyun.crm.common.enums.AllocType;
import cn.kinyun.crm.common.enums.LeadsStatus;
import cn.kinyun.crm.common.enums.SysConfEnum;
import cn.kinyun.crm.common.utils.IdGen;
import cn.kinyun.crm.dal.config.entity.LeadsConfig;
import cn.kinyun.crm.dal.config.entity.SysConfig;
import cn.kinyun.crm.dal.config.mapper.LeadsConfigMapper;
import cn.kinyun.crm.dal.config.mapper.SysConfigMapper;
import cn.kinyun.crm.dal.leads.mapper.DeptLibMapper;
import cn.kinyun.crm.dal.leads.mapper.LeadsLibMapper;
import cn.kinyun.crm.dal.leads.mapper.RawLeadsLibMapper;
import cn.kinyun.crm.sal.conf.service.ProductLineService;
import cn.kinyun.crm.sal.conf.service.SysConfigService;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.LoginUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysConfigServiceImpl
implements SysConfigService {
    private static final Logger log = LoggerFactory.getLogger(SysConfigServiceImpl.class);
    @Autowired
    SysConfigMapper sysConfigMapper;
    @Autowired
    ProductLineService productLineService;
    @Autowired
    DeptLibMapper deptLibMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private RawLeadsLibMapper rawLeadsLibMapper;
    @Autowired
    private LeadsLibMapper leadsLibMapper;
    @Autowired
    private ScrmUserService scrmUserService;
    @Resource
    private SettingService settingService;
    @Autowired
    private LeadsConfigMapper leadsConfigMapper;

    @Override
    public int isGuideFinished(Long bizId) {
        return this.getGuideConf(bizId).getGuideFinished();
    }

    @Override
    public GuideConf getGuideConf(Long bizId) {
        GuideConf guideConf;
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.GUIDE));
        GuideConf guideConf2 = guideConf = sysConfig != null ? (GuideConf)JSONObject.parseObject((String)sysConfig.getContent(), GuideConf.class) : GuideConf.builder().build();
        if (guideConf.getGuideFinished() == null) {
            guideConf.setGuideFinished(Integer.valueOf(0));
        }
        if (guideConf.getProductLineMulti() == null) {
            guideConf.setProductLineMulti(Integer.valueOf(0));
        }
        if (guideConf.getSalesModel() == null) {
            guideConf.setSalesModel(Integer.valueOf(0));
        }
        if (guideConf.getNeedShuffle() == null) {
            guideConf.setNeedShuffle(Integer.valueOf(0));
        }
        if (guideConf.getNeedDeptLib() == null) {
            guideConf.setNeedDeptLib(Integer.valueOf(0));
        }
        return guideConf;
    }

    @Override
    public SalesModelConf getSalesModeConf(Long biz) {
        GuideConf guideConf = this.getGuideConf(biz);
        MultiFollowConf multiFollowConf = this.getMultiFollowConf(biz);
        return SalesModelConf.builder().salesModel(guideConf.getSalesModel()).multiFollow(multiFollowConf.getMultiFollow()).multiFollowLimit(multiFollowConf.getMultiFollowLimit()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(GuideConf guideConf, Long bizId) {
        SysConfig sysConfig;
        if (guideConf.checkGuideFinished()) {
            guideConf.setGuideFinished(Integer.valueOf(1));
        }
        if ((sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.GUIDE))) == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.GUIDE.getType())).build();
            if (CollectionUtils.isEmpty(this.productLineService.list())) {
                this.productLineService.add(ProductLineDto.builder().name("\u9ed8\u8ba4\u9500\u552e\u7ebf").remark("\u9ed8\u8ba4\u9500\u552e\u7ebf").build());
            }
        } else {
            List rawLeadsLibs;
            GuideConf exists = (GuideConf)JSONObject.parseObject((String)sysConfig.getContent(), GuideConf.class);
            if (exists.getProductLineMulti() == 1 && guideConf.getProductLineMulti() == 0 && this.productLineService.list().size() > 1) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62b1\u6b49\uff0c\u56e0\u4e3a\u591a\u9500\u552e\u7ebf\u6d89\u53ca\u4e0d\u540c\u7684\u6570\u636e\u5408\u5e76\uff0c\u6682\u65e0\u6cd5\u4fee\u6539");
            }
            if (exists.getNeedDeptLib() == 1 && guideConf.getNeedDeptLib() == 0 && this.deptLibMapper.countByBiz(bizId) > 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u5b58\u5728\u90e8\u95e8\u516c\u6d77\u6570\u636e\uff0c\u9700\u8981\u5148\u91ca\u653e\u624d\u80fd\u8bbe\u7f6e\u4e3a\u4e0d\u9700\u8981");
            }
            if (exists.getNeedShuffle() == 1 && guideConf.getNeedShuffle() == 0 && CollectionUtils.isNotEmpty((Collection)(rawLeadsLibs = this.rawLeadsLibMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"alloc_type", (Object)AllocType.CUSTOMER_SERVICE.getValue()))))) {
                ArrayList leadsIds = Lists.newArrayList();
                ArrayList rawLeadsIds = Lists.newArrayList();
                rawLeadsLibs.forEach(rawLeadsLib -> {
                    rawLeadsIds.add(rawLeadsLib.getId());
                    leadsIds.add(rawLeadsLib.getLeadsLibId());
                });
                this.rawLeadsLibMapper.updateByIds(bizId, null, Integer.valueOf(AllocType.AUTO_ALLOC.getValue()), null, null, null, null, new Date(), (Collection)rawLeadsIds);
                this.leadsLibMapper.updateStatus(bizId, (List)leadsIds, LeadsStatus.AUTO_ALLOC.getValue());
            }
        }
        sysConfig.setContent(JSONObject.toJSONString((Object)guideConf));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
    }

    @Override
    public MultiFollowConf getMultiFollowConf(Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.PRODUCT_LINE));
        MultiFollowConf multiFollowConf = sysConfig != null ? (MultiFollowConf)JSONObject.parseObject((String)sysConfig.getContent(), MultiFollowConf.class) : MultiFollowConf.builder().build();
        return multiFollowConf;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MultiFollowConf multiFollowConf, Long bizId) {
        Preconditions.checkArgument((multiFollowConf.getMultiFollow() != null ? 1 : 0) != 0, (Object)"");
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.PRODUCT_LINE));
        if (sysConfig == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.PRODUCT_LINE.getType())).build();
        }
        sysConfig.setContent(JSONObject.toJSONString((Object)multiFollowConf));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
    }

    @Override
    public ReleaseConf getReleaseConf(Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.TRANSFER));
        ReleaseConf releaseConf = sysConfig != null ? (ReleaseConf)JSONObject.parseObject((String)sysConfig.getContent(), ReleaseConf.class) : new ReleaseConf();
        return releaseConf;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(ReleaseConf releaseConf, Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.TRANSFER));
        if (sysConfig == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.TRANSFER.getType())).build();
        }
        sysConfig.setContent(JSONObject.toJSONString((Object)releaseConf));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
    }

    @Override
    public OrderAmountConf getOrderAmountConf(Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.ORDER_AMOUNT));
        OrderAmountConf orderAmountConf = sysConfig != null ? (OrderAmountConf)JSONObject.parseObject((String)sysConfig.getContent(), OrderAmountConf.class) : OrderAmountConf.builder().build();
        return orderAmountConf;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(OrderAmountConf orderAmountConf, Long bizId) {
        Preconditions.checkArgument((orderAmountConf.getOrderFlushAmount() != null ? 1 : 0) != 0);
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.ORDER_AMOUNT));
        if (sysConfig == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.ORDER_AMOUNT.getType())).build();
        }
        sysConfig.setContent(JSONObject.toJSONString((Object)orderAmountConf));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
    }

    @Override
    public MobileEncryConf getMobileEncryConf(Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.MOBILE_ENCRYPT));
        MobileEncryConf mobileEncryConf = sysConfig != null ? (MobileEncryConf)JSONObject.parseObject((String)sysConfig.getContent(), MobileEncryConf.class) : MobileEncryConf.builder().build();
        return mobileEncryConf;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MobileEncryConf mobileEncryConf, Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.MOBILE_ENCRYPT));
        if (sysConfig == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.MOBILE_ENCRYPT.getType())).build();
        }
        sysConfig.setContent(JSONObject.toJSONString((Object)mobileEncryConf));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
    }

    @Override
    public SalesAreaSwitch getSalesAreaSwitch(Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.SALES_AREA));
        SalesAreaSwitch salesAreaSwitch = sysConfig != null ? (SalesAreaSwitch)JSONObject.parseObject((String)sysConfig.getContent(), SalesAreaSwitch.class) : SalesAreaSwitch.builder().isOpen(0).build();
        return salesAreaSwitch;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SalesAreaSwitch salesAreaSwitch, Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.SALES_AREA));
        if (sysConfig == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.SALES_AREA.getType())).build();
        }
        sysConfig.setContent(JSONObject.toJSONString((Object)salesAreaSwitch));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
    }

    @Override
    public ShuffleRuleDefault getShuffleRuleDefault(Long bizId) {
        ShuffleRuleDefault shuffleRuleDefault;
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.SHUFFLE_RULE));
        ShuffleRuleDefault shuffleRuleDefault2 = shuffleRuleDefault = sysConfig != null ? (ShuffleRuleDefault)JSONObject.parseObject((String)sysConfig.getContent(), ShuffleRuleDefault.class) : null;
        if (shuffleRuleDefault == null) {
            shuffleRuleDefault = ShuffleRuleDefault.builder().option(0).build();
        } else {
            shuffleRuleDefault.setUpdateTime(sysConfig.getUpdateTime());
            shuffleRuleDefault.setUpdateByName((String)this.scrmUserService.getNameByIds((Collection)Sets.newHashSet((Object[])new Long[]{sysConfig.getUpdateBy()})).get(sysConfig.getUpdateBy()));
        }
        return shuffleRuleDefault;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(ShuffleRuleDefault shuffleRuleDefault, Long bizId) {
        SysConfig sysConfig;
        if (shuffleRuleDefault.getOption() == 2) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)shuffleRuleDefault.getMemberInfos()), (Object)"member is null");
        }
        if ((sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.SHUFFLE_RULE))) == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.SHUFFLE_RULE.getType())).build();
        }
        sysConfig.setContent(JSONObject.toJSONString((Object)shuffleRuleDefault));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
    }

    @Override
    public AllocRuleDefault getAllocRuleDefault(Long bizId) {
        AllocRuleDefault allocRuleDefault;
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.ALLOC_RULE));
        AllocRuleDefault allocRuleDefault2 = allocRuleDefault = sysConfig != null ? (AllocRuleDefault)JSONObject.parseObject((String)sysConfig.getContent(), AllocRuleDefault.class) : null;
        if (allocRuleDefault == null) {
            allocRuleDefault = AllocRuleDefault.builder().option(0).allocMode(AllocMode.ROUND.getValue()).build();
        } else {
            allocRuleDefault.setUpdateTime(sysConfig.getUpdateTime());
            allocRuleDefault.setUpdateByName((String)this.scrmUserService.getNameByIds((Collection)Sets.newHashSet((Object[])new Long[]{sysConfig.getUpdateBy()})).get(sysConfig.getUpdateBy()));
        }
        return allocRuleDefault;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(AllocRuleDefault allocRuleDefault, Long bizId) {
        SysConfig sysConfig;
        if (allocRuleDefault.getOption() > 0) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)allocRuleDefault.getMemberInfos()), (Object)"member is null");
        }
        if ((sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.ALLOC_RULE))) == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.ALLOC_RULE.getType())).build();
        }
        sysConfig.setContent(JSONObject.toJSONString((Object)allocRuleDefault));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
    }

    @Override
    public boolean listMobileEncry(Long bizId) {
        return this.settingService.getMobileEncrypt(bizId);
    }

    @Override
    public boolean detailListMobileEncry(Long bizId) {
        return this.settingService.getMobileEncrypt(bizId);
    }

    private QueryWrapper<SysConfig> queryWrapper(Long bizId, SysConfEnum sysConfEnum) {
        return (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"`type`", (Object)sysConfEnum.getType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(FollowActionConf followActionConf, Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.FOLLOW_ACTION));
        if (sysConfig == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.FOLLOW_ACTION.getType())).build();
        }
        sysConfig.setContent(JSONObject.toJSONString((Object)followActionConf));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
    }

    @Override
    public boolean isCallAsFollowCount(Long bizId) {
        FollowActionConf conf = this.toConf(bizId);
        return conf.getCall() == NumberUtils.INTEGER_ONE.intValue();
    }

    @Override
    public boolean isSmsAsFollowCount(Long bizId) {
        FollowActionConf conf = this.toConf(bizId);
        return conf.getSms() == NumberUtils.INTEGER_ONE.intValue();
    }

    @Override
    public boolean isWeworkChatAsFollowCount(Long bizId) {
        FollowActionConf conf = this.toConf(bizId);
        return conf.getWeworkChat() == NumberUtils.INTEGER_ONE.intValue();
    }

    @Override
    public List<NoRepeatFieldConf> getNoRepeatFieldConf(Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.NO_REPEAT_FIELD));
        NoRepeatFieldListConf noRepeatFieldListConf = sysConfig != null ? (NoRepeatFieldListConf)JSONObject.parseObject((String)sysConfig.getContent(), NoRepeatFieldListConf.class) : NoRepeatFieldListConf.builder().fields(NoRepeatFieldListConf.initNoRepeatFieldConf()).build();
        return noRepeatFieldListConf.getFields();
    }

    @Override
    public void save(NoRepeatFieldConf noRepeatFieldConf, Long bizId) {
        List fields;
        log.info("save noRepeatFieldConf:{},bizId:{}", (Object)noRepeatFieldConf, (Object)bizId);
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.NO_REPEAT_FIELD));
        if (sysConfig == null) {
            sysConfig = SysConfig.builder().num(this.idGen.getNum()).bizId(bizId).type(Integer.valueOf(SysConfEnum.NO_REPEAT_FIELD.getType())).build();
            fields = NoRepeatFieldListConf.initNoRepeatFieldConf();
        } else {
            fields = ((NoRepeatFieldListConf)JSONObject.parseObject((String)sysConfig.getContent(), NoRepeatFieldListConf.class)).getFields();
        }
        fields.forEach(field -> {
            if (field.getField().equals(noRepeatFieldConf.getField())) {
                field.setIsOpen(noRepeatFieldConf.getIsOpen());
            }
        });
        NoRepeatFieldListConf noRepeatFieldListConf = new NoRepeatFieldListConf();
        noRepeatFieldListConf.setFields(fields);
        sysConfig.setContent(JSONObject.toJSONString((Object)noRepeatFieldListConf));
        sysConfig.setBizId(LoginUtils.getCurrentUserBizId());
        sysConfig.setCorpId(LoginUtils.getCurrentUserCorpId());
        if (sysConfig.getId() == null) {
            sysConfig.setCreateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            sysConfig.setCreateTime(new Date());
            this.sysConfigMapper.insert((Object)sysConfig);
        } else {
            sysConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            sysConfig.setUpdateTime(new Date());
            this.sysConfigMapper.updateById((Object)sysConfig);
        }
        LeadsConfig leadsConfig = (LeadsConfig)this.leadsConfigMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"field_name", (Object)noRepeatFieldConf.getField()));
        if (leadsConfig == null) {
            return;
        }
        leadsConfig.setUpdateBy(LoginUtils.getCurrentUserId());
        leadsConfig.setUpdateTime(new Date());
        this.leadsConfigMapper.updateById((Object)leadsConfig);
    }

    @Override
    public boolean openNoRepeat(Long bizId, String fieldName) {
        List<NoRepeatFieldConf> noRepeatFieldConfs = this.getNoRepeatFieldConf(bizId);
        Optional<NoRepeatFieldConf> nameNoRepeatFieldConf = noRepeatFieldConfs.stream().filter(noRepeatFieldConf -> noRepeatFieldConf.getIsOpen() == 1 && noRepeatFieldConf.getField().equals(fieldName)).findAny();
        if (nameNoRepeatFieldConf.isPresent()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public FollowActionConf getFollowActionConf(Long bizId) {
        return this.toConf(bizId);
    }

    private FollowActionConf toConf(Long bizId) {
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne(this.queryWrapper(bizId, SysConfEnum.FOLLOW_ACTION));
        return sysConfig != null ? (FollowActionConf)JSONObject.parseObject((String)sysConfig.getContent(), FollowActionConf.class) : FollowActionConf.builder().build();
    }
}

