/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.impl;

import cn.kinyun.crm.common.dto.StrIdAndNameDto;
import cn.kinyun.crm.common.dto.conf.ProductLineDto;
import cn.kinyun.crm.common.dto.conf.SalesAreaSwitch;
import cn.kinyun.crm.common.dto.conf.req.SalesAreaRulesAddReq;
import cn.kinyun.crm.common.dto.conf.req.SalesAreaRulesListReq;
import cn.kinyun.crm.common.dto.conf.resp.CrmAreaDto;
import cn.kinyun.crm.common.dto.conf.resp.SalesAreaRulesResp;
import cn.kinyun.crm.common.utils.IdGen;
import cn.kinyun.crm.dal.config.entity.SalesAreaRules;
import cn.kinyun.crm.dal.config.mapper.SalesAreaRulesMapper;
import cn.kinyun.crm.dal.dto.SalesAreaRuleQueryDto;
import cn.kinyun.crm.sal.conf.service.ProductLineService;
import cn.kinyun.crm.sal.conf.service.SalesAreaRulesService;
import cn.kinyun.crm.sal.conf.service.SysConfigService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.UserRoleRespDto;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.AreaService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.AreaDto;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalesAreaRulesServiceImpl
implements SalesAreaRulesService {
    private static final Logger log = LoggerFactory.getLogger(SalesAreaRulesServiceImpl.class);
    @Autowired
    private SalesAreaRulesMapper salesAreaRulesMapper;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private ScrmUserService userService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ProductLineService productLineService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private AreaService areaService;
    @Autowired
    private SysConfigService sysConfigService;

    @Override
    public List<SalesAreaRulesResp> list(Long bizId, SalesAreaRulesListReq salesAreaRulesListReq) {
        PageDto pageDto;
        log.info("query sales area rules list with bizId={}, operatorId={}, req={}", new Object[]{bizId, LoginUtils.getCurrentUserId(), salesAreaRulesListReq});
        ArrayList result = Lists.newArrayList();
        Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
        if (StringUtils.isNotBlank((CharSequence)salesAreaRulesListReq.getDeptId())) {
            Long deptId = this.nodeService.getIdByNum(bizId, salesAreaRulesListReq.getDeptId());
            if (!manageNodeIds.contains(deptId)) {
                return result;
            }
            manageNodeIds = Sets.newHashSet((Object[])new Long[]{deptId});
        }
        HashSet manageUserIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)salesAreaRulesListReq.getUserId())) {
            manageUserIds.add(this.userService.getIdByNum(salesAreaRulesListReq.getUserId()));
        }
        if ((pageDto = salesAreaRulesListReq.getPageDto()) == null) {
            salesAreaRulesListReq.setPageDto(new PageDto());
            pageDto = salesAreaRulesListReq.getPageDto();
        }
        SalesAreaRuleQueryDto.SalesAreaRuleQueryDtoBuilder builder = SalesAreaRuleQueryDto.builder().deptIds(manageNodeIds).userIds((Set)manageUserIds).bizId(bizId);
        if (StringUtils.isNotBlank((CharSequence)salesAreaRulesListReq.getProductLineNum())) {
            builder.productLineId(this.productLineService.getProductLineId(salesAreaRulesListReq.getProductLineNum()));
        }
        if (StringUtils.isNotBlank((CharSequence)salesAreaRulesListReq.getAreaId())) {
            builder.areaId(this.areaService.getPrefix(salesAreaRulesListReq.getAreaId()));
        }
        PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize());
        Page ruleList = this.salesAreaRulesMapper.queryList(builder.build());
        pageDto.setCount(Integer.valueOf((int)ruleList.getTotal()));
        pageDto.setCurPageCount(Integer.valueOf(ruleList.size()));
        if (CollectionUtils.isNotEmpty((Collection)ruleList)) {
            HashSet deptIds = Sets.newHashSet();
            HashSet userIds = Sets.newHashSet();
            HashSet productLineIds = Sets.newHashSet();
            HashSet areaIds = Sets.newHashSet();
            for (SalesAreaRules rule2 : ruleList) {
                if (rule2.getDeptId() > 0L) {
                    deptIds.add(rule2.getDeptId());
                }
                if (rule2.getUserId() > 0L) {
                    userIds.add(rule2.getUserId());
                }
                userIds.add(rule2.getUpdateBy());
                productLineIds.add(rule2.getProductLineId());
                areaIds.addAll(Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)rule2.getAreaIds()));
            }
            HashMap nodeMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)deptIds)) {
                Map nodes = this.nodeService.getNodeByIds((Collection)deptIds, bizId);
                for (Long deptId : nodes.keySet()) {
                    Node node = (Node)nodes.get(deptId);
                    nodeMap.put(deptId, new StrIdAndNameDto(node.getNum(), node.getName()));
                }
            }
            HashMap userMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)userIds)) {
                userMap.putAll(this.userService.getUserInfoByIds((Collection)userIds).stream().collect(Collectors.toMap(UserSimpleInfo::getId, a -> new StrIdAndNameDto(a.getNum(), a.getName()))));
            }
            HashMap productLineMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)productLineIds)) {
                productLineMap.putAll(this.productLineService.getProductMap());
            }
            Map areaMap = this.areaService.getFullNames((Collection)areaIds);
            ruleList.forEach(rule -> result.add(this.convertRule((SalesAreaRules)rule, nodeMap, userMap, productLineMap, areaMap)));
        }
        return result;
    }

    private SalesAreaRulesResp convertRule(SalesAreaRules rule, Map<Long, StrIdAndNameDto> nodeMap, Map<Long, StrIdAndNameDto> userMap, Map<Long, ProductLineDto> productLineMap, Map<String, String> areaMap) {
        SalesAreaRulesResp resp = new SalesAreaRulesResp();
        resp.setId(rule.getNum());
        ArrayList areaInfoList = Lists.newArrayList();
        Splitter.on((String)",").omitEmptyStrings().split((CharSequence)rule.getAreaIds()).forEach(areaId -> areaInfoList.add(new StrIdAndNameDto(areaId, (String)areaMap.get(areaId))));
        resp.setAreaInfoList((List)areaInfoList);
        resp.setProductLine(productLineMap.get(rule.getProductLineId()));
        nodeMap.get(rule.getDeptId());
        resp.setDept(nodeMap.get(rule.getDeptId()));
        resp.setUser(userMap.get(rule.getUserId()));
        resp.setUpdateBy(userMap.get(rule.getUpdateBy()));
        resp.setUpdateTime(rule.getUpdateTime());
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(Long bizId, SalesAreaRulesAddReq salesAreaRulesAddReq) {
        SalesAreaRules rule;
        List<SalesAreaRules> existRules;
        log.info("add sales area rule with bizId={}, operatorId={}, req={}", new Object[]{bizId, LoginUtils.getCurrentUserId(), salesAreaRulesAddReq});
        List deptIds = salesAreaRulesAddReq.getDeptIds();
        List userIds = salesAreaRulesAddReq.getUserIds();
        if (CollectionUtils.isEmpty((Collection)deptIds) && CollectionUtils.isEmpty((Collection)userIds)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u914d\u7f6e\u90e8\u95e8\u548c\u914d\u7f6e\u4eba\u5458\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)salesAreaRulesAddReq.getProductLineNum()), (Object)"\u4ea7\u54c1\u7ebfID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)salesAreaRulesAddReq.getAreaIds()), (Object)"\u7ba1\u7406\u533a\u57df\u4e3a\u7a7a");
        Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
        ArrayList realDeptIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)deptIds) && (CollectionUtils.isEmpty((Collection)(realDeptIds = Lists.newArrayList(this.nodeService.getIdByNums(bizId, (Collection)deptIds).values()))) || !manageNodeIds.containsAll(realDeptIds))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u90e8\u95e8\u65e0\u7ba1\u7406\u6743\u9650");
        }
        HashMap userSimpleInfoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            List userInfoList = this.userService.getUserInfoByNums((Collection)userIds);
            userSimpleInfoMap.putAll(userInfoList.stream().collect(Collectors.toMap(a -> a.getId(), Function.identity())));
            if (!manageNodeIds.containsAll(userInfoList.stream().map(a -> a.getNodeId()).collect(Collectors.toSet()))) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u4eba\u5458\u65e0\u7ba1\u7406\u6743\u9650");
            }
        }
        if (CollectionUtils.isNotEmpty(existRules = this.queryPLineRulesByDeptIdOrUserId(bizId, this.productLineService.getProductLineId(salesAreaRulesAddReq.getProductLineNum()), realDeptIds, userSimpleInfoMap.keySet()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u90e8\u95e8\u6216\u4eba\u5458\u4e0b\u5df2\u7ecf\u5b58\u5728\u9500\u552e\u533a\u57df\u914d\u7f6e");
        }
        ArrayList rules = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)realDeptIds)) {
            for (Long deptId : realDeptIds) {
                rule = this.buildRule(bizId, salesAreaRulesAddReq.getAreaIds(), salesAreaRulesAddReq.getProductLineNum(), deptId, -1L);
                rules.add(rule);
            }
        }
        if (CollectionUtils.isNotEmpty(userSimpleInfoMap.keySet())) {
            for (Long userId : userSimpleInfoMap.keySet()) {
                rule = this.buildRule(bizId, salesAreaRulesAddReq.getAreaIds(), salesAreaRulesAddReq.getProductLineNum(), ((UserSimpleInfo)userSimpleInfoMap.get(userId)).getNodeId(), userId);
                rules.add(rule);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            this.salesAreaRulesMapper.insertBatch((List)rules);
        }
    }

    private SalesAreaRules buildRule(Long bizId, List<String> cityIds, String productLineNum, Long nodeId, Long userId) {
        SalesAreaRules rule = new SalesAreaRules();
        rule.setBizId(bizId);
        rule.setAreaIds("," + String.join((CharSequence)",", cityIds) + ",");
        rule.setNum(this.idGen.getNum());
        rule.setProductLineId(this.productLineService.getProductLineId(productLineNum));
        rule.setDeptId(Long.valueOf(nodeId == null ? -1L : nodeId));
        rule.setUserId(userId);
        rule.setCorpId(LoginUtils.getCurrentUserCorpId());
        rule.setCreateBy(LoginUtils.getCurrentUserId());
        rule.setUpdateBy(LoginUtils.getCurrentUserId());
        rule.setCreateTime(new Date());
        rule.setUpdateTime(new Date());
        return rule;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long bizId, List<String> nums) {
        log.info("delete sales area rules with bizId={}, operatorId={}, num={}", new Object[]{bizId, LoginUtils.getCurrentUserId(), nums});
        List<SalesAreaRules> rules = this.getRulesWithDataPermissionCheck(bizId, nums);
        if (CollectionUtils.isNotEmpty(rules)) {
            List ids = rules.stream().map(a -> a.getId()).collect(Collectors.toList());
            this.salesAreaRulesMapper.deleteByIds(ids);
        }
    }

    private SalesAreaRules getRuleWithDataPermissionCheck(Long bizId, String num) {
        List<SalesAreaRules> rules = this.getRulesWithDataPermissionCheck(bizId, Lists.newArrayList((Object[])new String[]{num}));
        if (CollectionUtils.isNotEmpty(rules)) {
            return rules.get(0);
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u533a\u57df\u914d\u7f6e\u4e0d\u5b58\u5728");
    }

    private List<SalesAreaRules> getRulesWithDataPermissionCheck(Long bizId, List<String> nums) {
        List rules = this.salesAreaRulesMapper.getByNums(bizId, nums);
        HashSet deptIds = Sets.newHashSet();
        for (SalesAreaRules rule : rules) {
            deptIds.add(rule.getDeptId());
        }
        if (CollectionUtils.isNotEmpty((Collection)deptIds) && !this.userRoleCommonService.getManageNodeIds().containsAll(deptIds)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65e0\u90e8\u95e8/\u4eba\u5458\u7ba1\u7406\u6743\u9650");
        }
        return rules;
    }

    @Override
    public List<CrmAreaDto> manageAreaList(Long bizId, SalesAreaRulesListReq salesAreaRulesListReq) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)salesAreaRulesListReq.getProductLineNum()), (Object)"\u9500\u552e\u7ebfID\u4e3a\u7a7a");
        List<CrmAreaDto> allAreas = this.getAllAreas();
        SalesAreaSwitch salesAreaSwitch = this.sysConfigService.getSalesAreaSwitch(bizId);
        if (!salesAreaSwitch.isOpen()) {
            return allAreas;
        }
        UserRoleRespDto curRole = LoginUtils.getCurrentUser().getCurRole();
        if (curRole != null && curRole.getRoleName().equals("\u7cfb\u7edf\u7ba1\u7406\u5458")) {
            return allAreas;
        }
        Map allAreaMap = allAreas.stream().collect(Collectors.toMap(a -> a.getValue(), Function.identity()));
        List<SalesAreaRules> rules = this.queryPLineRulesByDeptIdOrUserId(bizId, this.productLineService.getProductLineId(salesAreaRulesListReq.getProductLineNum()), null, Lists.newArrayList((Object[])new Long[]{LoginUtils.getCurrentUserId()}));
        if (CollectionUtils.isEmpty(rules)) {
            rules = this.queryPLineRulesByDeptIdOrUserId(bizId, this.productLineService.getProductLineId(salesAreaRulesListReq.getProductLineNum()), Lists.newArrayList((Object[])new Long[]{LoginUtils.getCurrentUser().getUserNodeId()}), null);
        }
        if (CollectionUtils.isEmpty(rules)) {
            return Collections.emptyList();
        }
        HashSet areaIds = Sets.newHashSet();
        for (SalesAreaRules rule : rules) {
            areaIds.addAll(Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)rule.getAreaIds()));
        }
        List provinceIds = areaIds.stream().filter(a -> this.getProvinceId((String)a).equals(a)).collect(Collectors.toList());
        Map<String, List<String>> pId2CIdMap = areaIds.stream().filter(a -> !this.getProvinceId((String)a).equals(a)).collect(Collectors.groupingBy(this::getProvinceId));
        ArrayList result = Lists.newArrayList();
        for (String provinceId : provinceIds) {
            result.add(allAreaMap.get(provinceId));
        }
        for (String provinceId : pId2CIdMap.keySet()) {
            List<String> cityIds = pId2CIdMap.get(provinceId);
            CrmAreaDto crmAreaDto = (CrmAreaDto)allAreaMap.get(provinceId);
            List cities = crmAreaDto.getChildren().stream().filter(a -> cityIds.contains(a.getValue())).collect(Collectors.toList());
            crmAreaDto.setChildren(cities);
            result.add(crmAreaDto);
        }
        result.sort(Comparator.comparing(CrmAreaDto::getValue));
        return result;
    }

    private List<CrmAreaDto> getAllAreas() {
        ArrayList specialProvinceId = Lists.newArrayList((Object[])new String[]{"110000", "120000", "310000", "500000"});
        Map allAreas = this.areaService.getAll();
        ArrayList provinces = Lists.newArrayList();
        HashMap pid2CitiesMap = Maps.newHashMap();
        for (AreaDto areaDto : allAreas.values()) {
            List list;
            String provinceId = this.getProvinceId(areaDto.getId());
            if (areaDto.getLevel() == 1) {
                provinces.add(new CrmAreaDto(areaDto.getId(), areaDto.getName(), (List)Lists.newArrayList()));
            }
            if (areaDto.getLevel() == 2 && !specialProvinceId.contains(provinceId)) {
                list = pid2CitiesMap.getOrDefault(provinceId, Lists.newArrayList());
                list.add(new CrmAreaDto(areaDto.getId(), areaDto.getName(), (List)Lists.newArrayList()));
                pid2CitiesMap.put(provinceId, list);
            }
            if (areaDto.getLevel() != 3 || !specialProvinceId.contains(provinceId)) continue;
            list = pid2CitiesMap.getOrDefault(provinceId, Lists.newArrayList());
            list.add(new CrmAreaDto(areaDto.getId(), areaDto.getName(), (List)Lists.newArrayList()));
            pid2CitiesMap.put(provinceId, list);
        }
        Comparator<CrmAreaDto> comparator = Comparator.comparing(CrmAreaDto::getValue);
        provinces.sort(comparator);
        provinces.forEach(p -> {
            List cities = (List)pid2CitiesMap.get(p.getValue());
            if (CollectionUtils.isNotEmpty((Collection)cities)) {
                cities.sort(comparator);
                p.setChildren(cities);
            }
        });
        return provinces;
    }

    private String getProvinceId(String areaId) {
        return areaId.substring(0, 2) + "0000";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mod(Long bizId, SalesAreaRulesAddReq salesAreaRulesAddReq) {
        Long productLineId;
        log.info("mod sales area rule with bizId={}, operatorId={}, req={}", new Object[]{bizId, LoginUtils.getCurrentUserId(), salesAreaRulesAddReq});
        SalesAreaRules rule = this.getRuleWithDataPermissionCheck(bizId, salesAreaRulesAddReq.getId());
        rule.setAreaIds("," + String.join((CharSequence)",", salesAreaRulesAddReq.getAreaIds()) + ",");
        if (StringUtils.isNotBlank((CharSequence)salesAreaRulesAddReq.getProductLineNum()) && (productLineId = this.productLineService.getProductLineId(salesAreaRulesAddReq.getProductLineNum())) != null && !productLineId.equals(rule.getProductLineId())) {
            List<SalesAreaRules> salesAreaRules = rule.getUserId() > 0L ? this.queryPLineRulesByDeptIdOrUserId(bizId, productLineId, null, Lists.newArrayList((Object[])new Long[]{rule.getUserId()})) : this.queryPLineRulesByDeptIdOrUserId(bizId, productLineId, Lists.newArrayList((Object[])new Long[]{rule.getDeptId()}), null);
            Preconditions.checkArgument((boolean)CollectionUtils.isEmpty(salesAreaRules), (Object)"\u90e8\u95e8\u6216\u4eba\u5458\u5728\u8be5\u9500\u552e\u7ebf\u4e0b\u5b58\u5728\u9500\u552e\u533a\u57df\u914d\u7f6e");
            rule.setProductLineId(productLineId);
        }
        rule.setUpdateBy(LoginUtils.getCurrentUserId());
        rule.setUpdateTime(new Date());
        this.salesAreaRulesMapper.updateById((Object)rule);
    }

    @Override
    public Map<Long, Set<String>> getUserPLineManageAreaList(Long bizId, Long productLineId, Collection<Long> userIds) {
        log.info("get user manage area with bizId={}, userIds={}", (Object)bizId, userIds);
        if (productLineId == null || CollectionUtils.isEmpty(userIds)) {
            return Maps.newHashMap();
        }
        List<SalesAreaRules> rules = this.queryPLineRulesByDeptIdOrUserId(bizId, productLineId, null, userIds);
        HashMap userId2AreaIdsMap = Maps.newHashMap();
        for (SalesAreaRules rule : rules) {
            List areaIds = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)rule.getAreaIds());
            Set set = userId2AreaIdsMap.getOrDefault(rule.getUserId(), Sets.newHashSet());
            set.addAll(areaIds);
            userId2AreaIdsMap.put(rule.getUserId(), set);
        }
        Set haveRuleUserIds = rules.stream().map(a -> a.getUserId()).collect(Collectors.toSet());
        Set notHaveRuleUserIds = userIds.stream().filter(a -> !haveRuleUserIds.contains(a)).collect(Collectors.toSet());
        HashMap userId2DeptIdMap = Maps.newHashMap();
        HashSet deptIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(notHaveRuleUserIds)) {
            List userInfoList = this.userService.getUserInfoByIds(notHaveRuleUserIds);
            for (UserSimpleInfo userInfo : userInfoList) {
                deptIds.add(userInfo.getNodeId());
                userId2DeptIdMap.put(userInfo.getId(), userInfo.getNodeId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)deptIds)) {
            HashMap deptId2AreaIdsMap = Maps.newHashMap();
            List<SalesAreaRules> deptRules = this.queryPLineRulesByDeptIdOrUserId(bizId, productLineId, deptIds, null);
            for (SalesAreaRules rule : deptRules) {
                List areaIds = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)rule.getAreaIds());
                deptId2AreaIdsMap.put(rule.getDeptId(), Sets.newHashSet((Iterable)areaIds));
            }
            for (Long userId : notHaveRuleUserIds) {
                Long deptId = (Long)userId2DeptIdMap.get(userId);
                userId2AreaIdsMap.put(userId, deptId2AreaIdsMap.getOrDefault(deptId, Sets.newHashSet()));
            }
        }
        return userId2AreaIdsMap;
    }

    @Override
    public Map<Long, Set<String>> getUserManageAreaMap(Long bizId, Long userId) {
        HashMap result = Maps.newHashMap();
        if (userId != null) {
            List salesAreaRules = this.salesAreaRulesMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"user_id", (Object)userId));
            List pIds = salesAreaRules.stream().map(a -> a.getProductLineId()).collect(Collectors.toList());
            pIds.add(-1L);
            UserSimpleInfo userInfo = this.userService.getById(userId);
            if (userInfo == null) {
                return result;
            }
            Long nodeId = userInfo.getNodeId();
            salesAreaRules.addAll(this.salesAreaRulesMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"dept_id", (Object)nodeId)).lt((Object)"user_id", (Object)0)).notIn((Object)"product_line_id", pIds)));
            if (CollectionUtils.isNotEmpty((Collection)salesAreaRules)) {
                HashMap pId2AreaIdsMap = Maps.newHashMap();
                salesAreaRules.forEach(rule -> {
                    Set areaIds = pId2AreaIdsMap.getOrDefault(rule.getProductLineId(), Sets.newHashSet());
                    areaIds.addAll(Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)rule.getAreaIds()));
                    pId2AreaIdsMap.put(rule.getProductLineId(), areaIds);
                });
                return pId2AreaIdsMap;
            }
        }
        return result;
    }

    private List<SalesAreaRules> queryPLineRulesByDeptIdOrUserId(Long bizId, Long productLineId, Collection<Long> deptIds, Collection<Long> userIds) {
        ArrayList rules = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(deptIds)) {
            rules.addAll(this.salesAreaRulesMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"product_line_id", (Object)productLineId)).in((Object)"dept_id", deptIds)).lt((Object)"user_id", (Object)0L)));
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            rules.addAll(this.salesAreaRulesMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"product_line_id", (Object)productLineId)).in((Object)"user_id", userIds)));
        }
        return rules;
    }
}

