/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.impl;

import cn.kinyun.crm.common.dto.StrIdAndNameDto;
import cn.kinyun.crm.common.dto.conf.AllocRuleDefault;
import cn.kinyun.crm.common.dto.conf.AllocRuleMatchResult;
import cn.kinyun.crm.common.dto.conf.ShuffleRuleDefault;
import cn.kinyun.crm.common.dto.conf.ShuffleRuleMatchResult;
import cn.kinyun.crm.common.dto.conf.resp.AllocRuleRespDto;
import cn.kinyun.crm.common.dto.conf.resp.ShuffleRuleRespDto;
import cn.kinyun.crm.common.enums.AllocMode;
import cn.kinyun.crm.common.enums.ExpressionOp;
import cn.kinyun.crm.common.enums.LeadsFieldSysEnum;
import cn.kinyun.crm.dal.config.entity.LeadsAllocRules;
import cn.kinyun.crm.dal.config.entity.LeadsShuffleRules;
import cn.kinyun.crm.dal.config.mapper.LeadsAllocRulesMapper;
import cn.kinyun.crm.dal.config.mapper.LeadsShuffleRulesMapper;
import cn.kinyun.crm.dal.leads.entity.LeadsLib;
import cn.kinyun.crm.sal.conf.service.LeadsConfService;
import cn.kinyun.crm.sal.conf.service.ProductLineService;
import cn.kinyun.crm.sal.conf.service.RuleMatchService;
import cn.kinyun.crm.sal.conf.service.SysConfigService;
import cn.kinyun.crm.sal.conf.service.dto.expression.AndExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.ContainAllExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.ContainAnyExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.EqExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.Expression;
import cn.kinyun.crm.sal.conf.service.dto.expression.GeExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.GtExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.IsNullExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.LeExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.LtExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.NotContainExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.NotEqExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.NotNullExpression;
import cn.kinyun.crm.sal.conf.service.dto.expression.OrExpression;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.AreaService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.ChannelDto;
import com.kuaike.scrm.common.service.dto.resp.StageDto;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RuleMatchServiceImpl
implements RuleMatchService {
    @Autowired
    ProductLineService productLineService;
    @Autowired
    LeadsShuffleRulesMapper leadsShuffleRulesMapper;
    @Autowired
    LeadsAllocRulesMapper leadsAllocRulesMapper;
    @Autowired
    LeadsConfService leadsConfService;
    @Autowired
    ScrmUserService scrmUserService;
    @Autowired
    AreaService areaService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    NodeService nodeService;

    @Override
    public ShuffleRuleMatchResult matchShuffleRules(Long bizId, LeadsLib leadsLib, List<String> tagIds) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((leadsLib != null ? 1 : 0) != 0);
        ShuffleRuleMatchResult result = new ShuffleRuleMatchResult();
        List rulesList = this.leadsShuffleRulesMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"product_line_id", (Object)leadsLib.getProductLineId())).eq((Object)"biz_id", (Object)leadsLib.getBizId())).eq((Object)"enable", (Object)1));
        rulesList.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        rulesList = rulesList.stream().filter(rule -> {
            if (rule.getEnable() == 1) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getCityId()})) {
                    if (StringUtils.isBlank((CharSequence)leadsLib.getAreaId())) {
                        return false;
                    }
                    if (this.areaService.getChildrenIds(rule.getCityId(), true).contains(leadsLib.getAreaId())) {
                        return true;
                    }
                } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getProvinceId()})) {
                    if (StringUtils.isBlank((CharSequence)leadsLib.getAreaId())) {
                        return false;
                    }
                    if (this.areaService.getChildrenIds(rule.getProvinceId(), true).contains(leadsLib.getAreaId())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        int dayOfWeek = Calendar.getInstance().get(7);
        for (LeadsShuffleRules rule2 : rulesList) {
            ArrayList expressions = Lists.newArrayList();
            List expressionRespDtos = JSONObject.parseArray((String)rule2.getExpression(), ShuffleRuleRespDto.ExpressionRespDto.class);
            expressionRespDtos.forEach(expression -> {
                if (expression.getFieldName().equals(LeadsFieldSysEnum.MARKET_USER_ID.getFieldName()) || LeadsFieldSysEnum.MARKET_USER_ID.getRelateFields().contains(expression.getFieldName())) {
                    if (expression.getValue() != null) {
                        UserSimpleInfo userSimpleInfo = (UserSimpleInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), UserSimpleInfo.class);
                        expression.setValue((Object)userSimpleInfo.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                        List users = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), UserSimpleInfo.class);
                        expression.setValues(users.stream().map(UserSimpleInfo::getId).collect(Collectors.toList()));
                    }
                } else if (expression.getFieldName().equals("channelId")) {
                    if (expression.getValue() != null) {
                        ChannelDto channelDto = (ChannelDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), ChannelDto.class);
                        expression.setValue((Object)channelDto.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                        List channelDtos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), ChannelDto.class);
                        expression.setValues(channelDtos.stream().map(ChannelDto::getId).collect(Collectors.toList()));
                    }
                } else if (expression.getFieldName().equals("stageId")) {
                    if (expression.getValue() != null) {
                        StageDto stageDto = (StageDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), StageDto.class);
                        expression.setValue((Object)stageDto.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                        List stageDtos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), StageDto.class);
                        expression.setValues(stageDtos.stream().map(StageDto::getId).collect(Collectors.toList()));
                    }
                } else if (expression.getFieldName().equals(LeadsFieldSysEnum.AREA_ID.getFieldName()) || LeadsFieldSysEnum.AREA_ID.getRelateFields().contains(expression.getFieldName())) {
                    if (expression.getValue() != null) {
                        StrIdAndNameDto strIdAndNameDto = (StrIdAndNameDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), StrIdAndNameDto.class);
                        expression.setValue((Object)strIdAndNameDto.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                        List areas = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), StrIdAndNameDto.class);
                        expression.setValues(areas.stream().map(StrIdAndNameDto::getId).collect(Collectors.toList()));
                    }
                } else if (expression.getFieldName().equals("tagIds")) {
                    if (expression.getValue() != null) {
                        StrIdAndNameDto strIdAndNameDto = (StrIdAndNameDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), StrIdAndNameDto.class);
                        expression.setValue((Object)strIdAndNameDto.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                        List tags = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), StrIdAndNameDto.class);
                        expression.setValues(tags.stream().map(StrIdAndNameDto::getId).collect(Collectors.toList()));
                    }
                }
                if (expression.getOp() == ExpressionOp.EQ.getOp()) {
                    expressions.add(EqExpression.builder().fieldName(expression.getFieldName()).value(expression.getValue()).build());
                } else if (expression.getOp() == ExpressionOp.NE.getOp()) {
                    expressions.add(NotEqExpression.builder().fieldName(expression.getFieldName()).value(expression.getValue()).build());
                } else if (expression.getOp() == ExpressionOp.IS_NULL.getOp()) {
                    expressions.add(IsNullExpression.builder().fieldName(expression.getFieldName()).build());
                } else if (expression.getOp() == ExpressionOp.NOT_NULL.getOp()) {
                    expressions.add(NotNullExpression.builder().fieldName(expression.getFieldName()).build());
                } else if (expression.getOp() == ExpressionOp.CONTAINS_ANY.getOp()) {
                    expressions.add(ContainAnyExpression.builder().fieldName(expression.getFieldName()).values(expression.getValues()).build());
                } else if (expression.getOp() == ExpressionOp.CONTAINS_ALL.getOp()) {
                    expressions.add(ContainAllExpression.builder().fieldName(expression.getFieldName()).values(expression.getValues()).build());
                } else if (expression.getOp() == ExpressionOp.NOT_CONTAIN.getOp()) {
                    expressions.add(NotContainExpression.builder().fieldName(expression.getFieldName()).values(expression.getValues()).build());
                }
            });
            boolean match = false;
            if (CollectionUtils.isNotEmpty((Collection)expressions)) {
                Expression expression2 = null;
                expression2 = rule2.getLogic() == 0 ? new AndExpression(expressions) : new OrExpression(expressions);
                if (expression2.interpret(leadsLib, tagIds)) {
                    match = true;
                }
            } else {
                match = true;
            }
            if (!match) continue;
            List aimLists = JSONObject.parseArray((String)rule2.getAllocMemberInfo(), ShuffleRuleRespDto.AimDto.class);
            for (ShuffleRuleRespDto.AimDto aimDto : aimLists) {
                if (!aimDto.getDays().contains(dayOfWeek)) continue;
                List userIds = this.scrmUserService.getUserInfoByNums((Collection)aimDto.getUsers().stream().map(StrIdAndNameDto::getId).collect(Collectors.toList())).stream().map(UserSimpleInfo::getId).collect(Collectors.toList());
                result.setRuleId(rule2.getId());
                result.setOption(2);
                result.setAllocMode(rule2.getAllocMode().intValue());
                result.setSeq(rule2.getSeq());
                result.setUserIds(userIds);
                return result;
            }
        }
        result.setRuleId(Long.valueOf(0L));
        result.setAllocMode(AllocMode.ROUND.getValue());
        ShuffleRuleDefault defaultRule = this.sysConfigService.getShuffleRuleDefault(bizId);
        if (defaultRule != null) {
            result.setOption(defaultRule.getOption());
            if (defaultRule.getOption() == 2) {
                List userIds = this.scrmUserService.getUserInfoByNums((Collection)defaultRule.getMemberInfos().stream().map(StrIdAndNameDto::getId).collect(Collectors.toList())).stream().map(UserSimpleInfo::getId).collect(Collectors.toList());
                result.setUserIds(userIds);
            }
        } else {
            result.setOption(0);
        }
        return result;
    }

    @Override
    public AllocRuleMatchResult matchAllocRules(Long bizId, LeadsLib leadsLib, List<String> tagIds) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((leadsLib != null ? 1 : 0) != 0);
        List rulesList = this.leadsAllocRulesMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"product_line_id", (Object)leadsLib.getProductLineId())).eq((Object)"biz_id", (Object)leadsLib.getBizId())).eq((Object)"enable", (Object)1));
        rulesList.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        rulesList = rulesList.stream().filter(rule -> {
            if (rule.getEnable() == 1) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getCityId()})) {
                    if (StringUtils.isBlank((CharSequence)leadsLib.getAreaId())) {
                        return false;
                    }
                    if (this.areaService.getChildrenIds(rule.getCityId(), true).contains(leadsLib.getAreaId())) {
                        return true;
                    }
                } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getProvinceId()})) {
                    if (StringUtils.isBlank((CharSequence)leadsLib.getAreaId())) {
                        return false;
                    }
                    if (this.areaService.getChildrenIds(rule.getProvinceId(), true).contains(leadsLib.getAreaId())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        for (LeadsAllocRules rule2 : rulesList) {
            List<Expression> expressions = this.dealWithExpressions(rule2);
            if (CollectionUtils.isNotEmpty(expressions)) {
                Expression expression = null;
                expression = rule2.getLogic() == 0 ? new AndExpression(expressions) : new OrExpression(expressions);
                if (!expression.interpret(leadsLib, tagIds)) continue;
                return this.buildResult(rule2);
            }
            return this.buildResult(rule2);
        }
        AllocRuleDefault defaultRule = this.sysConfigService.getAllocRuleDefault(bizId);
        return this.buildResult(leadsLib.getBizId(), defaultRule);
    }

    @Override
    public List<AllocRuleMatchResult> allMatchAllocRules(Long bizId, LeadsLib leadsLib, List<String> tagIds) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((leadsLib != null ? 1 : 0) != 0);
        ArrayList result = Lists.newArrayList();
        List rulesList = this.leadsAllocRulesMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"product_line_id", (Object)leadsLib.getProductLineId())).eq((Object)"biz_id", (Object)leadsLib.getBizId()));
        rulesList.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        rulesList = rulesList.stream().filter(rule -> {
            if (rule.getEnable() == 1) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getCityId()})) {
                    if (StringUtils.isBlank((CharSequence)leadsLib.getAreaId())) {
                        return false;
                    }
                    if (this.areaService.getChildrenIds(rule.getCityId(), true).contains(leadsLib.getAreaId())) {
                        return true;
                    }
                } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getProvinceId()})) {
                    if (StringUtils.isBlank((CharSequence)leadsLib.getAreaId())) {
                        return false;
                    }
                    if (this.areaService.getChildrenIds(rule.getProvinceId(), true).contains(leadsLib.getAreaId())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        for (LeadsAllocRules rule2 : rulesList) {
            List<Expression> expressions = this.dealWithExpressions(rule2);
            if (CollectionUtils.isNotEmpty(expressions)) {
                Expression expression = null;
                expression = rule2.getLogic() == 0 ? new AndExpression(expressions) : new OrExpression(expressions);
                if (!expression.interpret(leadsLib, tagIds)) continue;
                result.add(this.buildResult(rule2));
                continue;
            }
            result.add(this.buildResult(rule2));
        }
        AllocRuleDefault defaultRule = this.sysConfigService.getAllocRuleDefault(bizId);
        result.add(this.buildResult(bizId, defaultRule));
        return result;
    }

    private AllocRuleMatchResult buildResult(Long bizId, AllocRuleDefault defaultRule) {
        AllocRuleMatchResult match = AllocRuleMatchResult.builder().ruleId(Long.valueOf(0L)).option(2).allocMode(AllocMode.RANDOM.getValue()).seq(Integer.valueOf(1000)).build();
        if (defaultRule != null) {
            match.setOption(defaultRule.getOption());
            if (defaultRule.getOption() == 2) {
                List userIds = this.scrmUserService.getUserInfoByNums((Collection)defaultRule.getMemberInfos().stream().map(StrIdAndNameDto::getId).collect(Collectors.toList())).stream().map(UserSimpleInfo::getId).collect(Collectors.toList());
                match.setUserIds(userIds);
            } else if (defaultRule.getOption() == 1) {
                ArrayList deptIds = Lists.newArrayList(this.nodeService.getIdByNums(bizId, (Collection)defaultRule.getMemberInfos().stream().map(StrIdAndNameDto::getId).collect(Collectors.toList())).values());
                match.setDeptIds((List)deptIds);
            }
        } else {
            match.setOption(0);
        }
        return match;
    }

    private AllocRuleMatchResult buildResult(LeadsAllocRules rule) {
        List members = JSONObject.parseArray((String)rule.getAllocMemberInfo(), StrIdAndNameDto.class);
        if (rule.getMemberType().equals(0)) {
            List userIds = this.scrmUserService.getUserInfoByNums((Collection)members.stream().map(StrIdAndNameDto::getId).collect(Collectors.toList())).stream().map(UserSimpleInfo::getId).collect(Collectors.toList());
            return AllocRuleMatchResult.builder().ruleId(rule.getId()).option(2).allocMode(rule.getAllocMode().intValue()).seq(rule.getSeq()).userIds(userIds).build();
        }
        List deptIds = this.scrmUserService.getUserInfoByNums((Collection)members.stream().map(StrIdAndNameDto::getId).collect(Collectors.toList())).stream().map(UserSimpleInfo::getId).collect(Collectors.toList());
        return AllocRuleMatchResult.builder().ruleId(rule.getId()).option(2).allocMode(rule.getAllocMode().intValue()).seq(rule.getSeq()).userIds((List)Lists.newArrayList((Iterable)this.scrmUserService.queryIdsByNodeIds(deptIds))).build();
    }

    @Override
    public boolean matchAllocRule(Long bizId, LeadsLib leadsLib, List<String> tagIds, Long ruleId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((ruleId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((leadsLib != null ? 1 : 0) != 0);
        ArrayList result = Lists.newArrayList();
        if (ruleId.equals(0L)) {
            return true;
        }
        LeadsAllocRules rule = (LeadsAllocRules)this.leadsAllocRulesMapper.selectById((Serializable)ruleId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getCityId()})) {
            if (StringUtils.isBlank((CharSequence)leadsLib.getAreaId())) {
                return false;
            }
            if (!this.areaService.getChildrenIds(rule.getCityId(), true).contains(leadsLib.getAreaId())) {
                return false;
            }
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getProvinceId()})) {
            if (StringUtils.isBlank((CharSequence)leadsLib.getAreaId())) {
                return false;
            }
            if (!this.areaService.getChildrenIds(rule.getProvinceId(), true).contains(leadsLib.getAreaId())) {
                return false;
            }
        }
        if (!leadsLib.getProductLineId().equals(rule.getProductLineId())) {
            return false;
        }
        List<Expression> expressions = this.dealWithExpressions(rule);
        if (CollectionUtils.isNotEmpty(expressions)) {
            Expression expression = null;
            expression = rule.getLogic() == 0 ? new AndExpression(expressions) : new OrExpression(expressions);
            return expression.interpret(leadsLib, tagIds);
        }
        return true;
    }

    private List<Expression> dealWithExpressions(LeadsAllocRules rule) {
        ArrayList expressions = Lists.newArrayList();
        List expressionRespDtos = JSONObject.parseArray((String)rule.getExpression(), AllocRuleRespDto.ExpressionRespDto.class);
        expressionRespDtos.forEach(expression -> {
            if (expression.getFieldName().equals(LeadsFieldSysEnum.MARKET_USER_ID.getFieldName()) || LeadsFieldSysEnum.MARKET_USER_ID.getRelateFields().contains(expression.getFieldName())) {
                if (expression.getValue() != null) {
                    UserSimpleInfo userSimpleInfo = (UserSimpleInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), UserSimpleInfo.class);
                    expression.setValue((Object)userSimpleInfo.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                    List users = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), UserSimpleInfo.class);
                    expression.setValues(users.stream().map(UserSimpleInfo::getId).collect(Collectors.toList()));
                }
            } else if (expression.getFieldName().equals("channelId")) {
                if (expression.getValue() != null) {
                    ChannelDto channelDto = (ChannelDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), ChannelDto.class);
                    expression.setValue((Object)channelDto.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                    List channelDtos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), ChannelDto.class);
                    expression.setValues(channelDtos.stream().map(ChannelDto::getId).collect(Collectors.toList()));
                }
            } else if (expression.getFieldName().equals("stageId")) {
                if (expression.getValue() != null) {
                    StageDto stageDto = (StageDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), StageDto.class);
                    expression.setValue((Object)stageDto.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                    List stageDtos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), StageDto.class);
                    expression.setValues(stageDtos.stream().map(StageDto::getId).collect(Collectors.toList()));
                }
            } else if (expression.getFieldName().equals(LeadsFieldSysEnum.AREA_ID.getFieldName()) || LeadsFieldSysEnum.AREA_ID.getRelateFields().contains(expression.getFieldName())) {
                if (expression.getValue() != null) {
                    StrIdAndNameDto strIdAndNameDto = (StrIdAndNameDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), StrIdAndNameDto.class);
                    expression.setValue((Object)strIdAndNameDto.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                    List areas = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), StrIdAndNameDto.class);
                    expression.setValues(areas.stream().map(StrIdAndNameDto::getId).collect(Collectors.toList()));
                }
            } else if (expression.getFieldName().equals("tagIds")) {
                if (expression.getValue() != null) {
                    StrIdAndNameDto strIdAndNameDto = (StrIdAndNameDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)expression.getValue()), StrIdAndNameDto.class);
                    expression.setValue((Object)strIdAndNameDto.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)expression.getValues())) {
                    List tags = JSONObject.parseArray((String)JSONObject.toJSONString((Object)expression.getValues()), StrIdAndNameDto.class);
                    expression.setValues(tags.stream().map(StrIdAndNameDto::getId).collect(Collectors.toList()));
                }
            }
            if (expression.getOp() == ExpressionOp.EQ.getOp()) {
                expressions.add(EqExpression.builder().fieldName(expression.getFieldName()).value(expression.getValue()).build());
            } else if (expression.getOp() == ExpressionOp.NE.getOp()) {
                expressions.add(NotEqExpression.builder().fieldName(expression.getFieldName()).value(expression.getValue()).build());
            } else if (expression.getOp() == ExpressionOp.LE.getOp()) {
                expressions.add(LeExpression.builder().fieldName(expression.getFieldName()).value(expression.getValue()).build());
            } else if (expression.getOp() == ExpressionOp.LT.getOp()) {
                expressions.add(LtExpression.builder().fieldName(expression.getFieldName()).value(expression.getValue()).build());
            } else if (expression.getOp() == ExpressionOp.GE.getOp()) {
                expressions.add(GeExpression.builder().fieldName(expression.getFieldName()).value(expression.getValue()).build());
            } else if (expression.getOp() == ExpressionOp.GT.getOp()) {
                expressions.add(GtExpression.builder().fieldName(expression.getFieldName()).value(expression.getValue()).build());
            } else if (expression.getOp() == ExpressionOp.IS_NULL.getOp()) {
                expressions.add(IsNullExpression.builder().fieldName(expression.getFieldName()).build());
            } else if (expression.getOp() == ExpressionOp.NOT_NULL.getOp()) {
                expressions.add(NotNullExpression.builder().fieldName(expression.getFieldName()).build());
            } else if (expression.getOp() == ExpressionOp.CONTAINS_ANY.getOp()) {
                expressions.add(ContainAnyExpression.builder().fieldName(expression.getFieldName()).values(expression.getValues()).build());
            } else if (expression.getOp() == ExpressionOp.CONTAINS_ALL.getOp()) {
                expressions.add(ContainAllExpression.builder().fieldName(expression.getFieldName()).values(expression.getValues()).build());
            } else if (expression.getOp() == ExpressionOp.NOT_CONTAIN.getOp()) {
                expressions.add(NotContainExpression.builder().fieldName(expression.getFieldName()).values(expression.getValues()).build());
            }
        });
        return expressions;
    }

    @Override
    public List<AllocRuleMatchResult> getAllocRuleList(Long bizId, Long productLineId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((productLineId != null ? 1 : 0) != 0);
        ArrayList result = Lists.newArrayList();
        List rulesList = this.leadsAllocRulesMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"product_line_id", (Object)productLineId)).eq((Object)"biz_id", (Object)bizId)).eq((Object)"enable", (Object)1));
        rulesList.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        ArrayList results = Lists.newArrayList();
        for (LeadsAllocRules rule : rulesList) {
            result.add(this.buildResult(rule));
        }
        AllocRuleDefault defaultRule = this.sysConfigService.getAllocRuleDefault(bizId);
        result.add(this.buildResult(bizId, defaultRule));
        return result;
    }
}

