/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.impl;

import cn.kinyun.crm.common.dto.conf.ProductLineDto;
import cn.kinyun.crm.common.utils.IdGen;
import cn.kinyun.crm.dal.config.entity.ProductLine;
import cn.kinyun.crm.dal.config.mapper.ProductLineMapper;
import cn.kinyun.crm.dal.leads.mapper.LeadsLibMapper;
import cn.kinyun.crm.dal.leads.mapper.RawLeadsLibMapper;
import cn.kinyun.crm.sal.conf.service.ProductLineService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.utils.LoginUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductLineServiceImpl
implements ProductLineService {
    @Autowired
    ProductLineMapper productLineMapper;
    @Autowired
    RawLeadsLibMapper rawLeadsLibMapper;
    @Autowired
    LeadsLibMapper leadsLibMapper;
    @Autowired
    private IdGen idGen;

    @Override
    public String add(ProductLineDto productLineDto) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineDto.getName()), (Object)"\u540d\u79f0\u4e3a\u7a7a");
        ProductLine exists = (ProductLine)this.productLineMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"name", (Object)productLineDto.getName())).eq((Object)"is_deleted", (Object)0));
        if (exists != null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u540d\u79f0\u91cd\u590d");
        }
        ProductLine record = new ProductLine();
        record.setNum(this.idGen.getNum());
        record.setBizId(LoginUtils.getCurrentUserBizId());
        record.setCorpId(LoginUtils.getCurrentUserCorpId());
        record.setName(productLineDto.getName());
        record.setRemark(productLineDto.getRemark());
        record.setCreateBy(LoginUtils.getCurrentUserId());
        record.setUpdateBy(LoginUtils.getCurrentUserId());
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setIsDeleted(Integer.valueOf(0));
        this.productLineMapper.insert((Object)record);
        return record.getNum();
    }

    @Override
    public String mod(ProductLineDto productLineDto) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineDto.getName()), (Object)"\u540d\u79f0\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineDto.getNum()), (Object)"\u7f16\u53f7\u4e3a\u7a7a");
        ProductLine exists = (ProductLine)this.productLineMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"name", (Object)productLineDto.getName())).eq((Object)"is_deleted", (Object)0));
        if (exists != null && !exists.getNum().equals(productLineDto.getNum())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u540d\u79f0\u91cd\u590d");
        }
        exists = (ProductLine)this.productLineMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"num", (Object)productLineDto.getNum()));
        if (exists == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9500\u552e\u7ebf\u4e0d\u5b58\u5728");
        }
        exists.setUpdateBy(LoginUtils.getCurrentUserId());
        exists.setUpdateTime(new Date());
        exists.setName(productLineDto.getName());
        exists.setRemark(productLineDto.getRemark());
        this.productLineMapper.updateById((Object)exists);
        return exists.getNum();
    }

    @Override
    public void delete(String productLineNum) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineNum), (Object)"\u7f16\u53f7\u4e3a\u7a7a");
        ProductLine exists = (ProductLine)this.productLineMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"num", (Object)productLineNum));
        if (exists == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9500\u552e\u7ebf\u4e0d\u5b58\u5728");
        }
        if (CollectionUtils.isNotEmpty((Collection)this.leadsLibMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)exists.getBizId())).eq((Object)"product_line_id", (Object)exists.getId())))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9500\u552e\u7ebf\u5df2\u7ecf\u88ab\u4f7f\u7528\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (CollectionUtils.isNotEmpty((Collection)this.rawLeadsLibMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)exists.getBizId())).eq((Object)"product_line_id", (Object)exists.getId())))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9500\u552e\u7ebf\u5df2\u7ecf\u88ab\u4f7f\u7528\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        exists.setIsDeleted(Integer.valueOf(1));
        exists.setUpdateBy(LoginUtils.getCurrentUserId());
        exists.setUpdateTime(new Date());
        this.productLineMapper.updateById((Object)exists);
    }

    @Override
    public ProductLineDto get(String productLineNum) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineNum), (Object)"\u7f16\u53f7\u4e3a\u7a7a");
        ProductLine exists = (ProductLine)this.productLineMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"num", (Object)productLineNum)).eq((Object)"is_deleted", (Object)0));
        if (exists == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9500\u552e\u7ebf\u4e0d\u5b58\u5728");
        }
        return ProductLineDto.builder().name(exists.getName()).num(exists.getNum()).remark(exists.getRemark()).build();
    }

    @Override
    public Long getProductLineId(String productLineNum) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineNum), (Object)"\u7f16\u53f7\u4e3a\u7a7a");
        Long id = this.productLineMapper.getIdByNum(LoginUtils.getCurrentUserBizId(), productLineNum);
        if (id == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9500\u552e\u7ebf\u4e0d\u5b58\u5728");
        }
        return id;
    }

    @Override
    public String getNumById(Long bizId, Long id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"\u9500\u552e\u7ebfid\u672a\u7a7a");
        String num = this.productLineMapper.getNumById(bizId, id);
        if (num == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9500\u552e\u7ebf\u4e0d\u5b58\u5728");
        }
        return num;
    }

    @Override
    public Map<String, Long> getNumIdMap() {
        return this.productLineMapper.selectList((Wrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).stream().collect(Collectors.toMap(ProductLine::getNum, ProductLine::getId));
    }

    @Override
    public Map<Long, String> getIdNumMap() {
        return this.productLineMapper.selectList((Wrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).stream().collect(Collectors.toMap(ProductLine::getId, ProductLine::getNum));
    }

    @Override
    public ProductLine getByNum(String productLineNum) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineNum), (Object)"\u7f16\u53f7\u4e3a\u7a7a");
        ProductLine productLine = (ProductLine)this.productLineMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"num", (Object)productLineNum)).eq((Object)"is_deleted", (Object)0));
        if (productLine == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9500\u552e\u7ebf\u627e\u4e0d\u5230");
        }
        return productLine;
    }

    @Override
    public ProductLine getById(Long productLineId) {
        Preconditions.checkArgument((productLineId != null ? 1 : 0) != 0, (Object)"id\u4e3a\u7a7a");
        ProductLine productLine = (ProductLine)this.productLineMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"id", (Object)productLineId)).eq((Object)"is_deleted", (Object)0));
        if (productLine == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9500\u552e\u7ebf\u672a\u627e\u5230");
        }
        return productLine;
    }

    @Override
    public List<ProductLineDto> list() {
        List lines = this.productLineMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"is_deleted", (Object)0));
        lines.sort((a, b) -> Long.compare(a.getId(), b.getId()));
        return lines.stream().map(a -> ProductLineDto.builder().name(a.getName()).num(a.getNum()).remark(a.getRemark()).build()).collect(Collectors.toList());
    }

    @Override
    public Map<Long, ProductLineDto> getProductMap() {
        return this.productLineMapper.selectList((Wrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).stream().collect(Collectors.toMap(ProductLine::getId, productLine -> ProductLineDto.builder().num(productLine.getNum()).name(productLine.getName()).remark(productLine.getRemark()).build()));
    }

    @Override
    public Long validateProductLineId(Long bizId, Long productLineId) {
        if (productLineId != null && productLineId > 0L) {
            String num = this.productLineMapper.getNumById(bizId, productLineId);
            Preconditions.checkArgument((num != null ? 1 : 0) != 0, (Object)"\u9500\u552e\u7ebf\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002");
            return productLineId;
        }
        List list = this.productLineMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"is_deleted", (Object)0)).orderByAsc((Object)"id"));
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new IllegalArgumentException("\u672a\u521d\u59cb\u5316\u9500\u552e\u7ebf\uff0c\u8bf7\u5148\u521d\u59cb\u5316CRM\u7cfb\u7edf\u3002");
        }
        return ((ProductLine)list.get(0)).getId();
    }

    @Override
    public String validateProductLineNum(Long bizId, String productLineNum) {
        if (StringUtils.isNotBlank((CharSequence)productLineNum)) {
            Long id = this.productLineMapper.getIdByNum(bizId, productLineNum);
            Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"\u9500\u552e\u7ebf\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002");
            return productLineNum;
        }
        List list = this.productLineMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"is_deleted", (Object)0)).orderByAsc((Object)"id"));
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new IllegalArgumentException("\u672a\u521d\u59cb\u5316\u9500\u552e\u7ebf\uff0c\u8bf7\u5148\u521d\u59cb\u5316CRM\u7cfb\u7edf\u3002");
        }
        return ((ProductLine)list.get(0)).getNum();
    }
}

