/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.impl;

import cn.kinyun.crm.common.dto.StrIdAndNameDto;
import cn.kinyun.crm.common.dto.conf.req.LeadsTransferRulesAddReq;
import cn.kinyun.crm.common.dto.conf.req.LeadsTransferRulesListReq;
import cn.kinyun.crm.common.dto.conf.resp.LeadsTransferRulesResp;
import cn.kinyun.crm.common.utils.IdGen;
import cn.kinyun.crm.dal.config.entity.LeadsTransferRules;
import cn.kinyun.crm.dal.config.mapper.LeadsTransferRulesMapper;
import cn.kinyun.crm.dal.dto.LeadsTransferRuleQueryDto;
import cn.kinyun.crm.sal.conf.service.LeadsTransferRulesService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LeadsTransferRulesServiceImpl
implements LeadsTransferRulesService {
    private static final Logger log = LoggerFactory.getLogger(LeadsTransferRulesServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private LeadsTransferRulesMapper leadsTransferRulesMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private ScrmUserService userService;
    @Autowired
    private NodeService nodeService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(Long bizId, LeadsTransferRulesAddReq leadsTransferRulesAddReq) {
        List<LeadsTransferRules> existRules;
        log.info("save or update leads transfer rule with bizId={}, operatorId={}\uff0creq={}", new Object[]{bizId, LoginUtils.getCurrentUserId(), leadsTransferRulesAddReq});
        List deptIds = leadsTransferRulesAddReq.getDeptIds();
        List userIds = leadsTransferRulesAddReq.getUserIds();
        if (CollectionUtils.isEmpty((Collection)deptIds) && CollectionUtils.isEmpty((Collection)userIds)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u914d\u7f6e\u90e8\u95e8\u548c\u914d\u7f6e\u4eba\u5458\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        leadsTransferRulesAddReq.commonValidate();
        Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
        ArrayList realDeptIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)deptIds) && !manageNodeIds.containsAll(realDeptIds = Lists.newArrayList(this.nodeService.getIdByNums(bizId, (Collection)deptIds).values()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u90e8\u95e8\u65e0\u7ba1\u7406\u6743\u9650");
        }
        HashMap userSimpleInfoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            List userInfoList = this.userService.getUserInfoByNums((Collection)userIds);
            userSimpleInfoMap.putAll(userInfoList.stream().collect(Collectors.toMap(a -> a.getId(), Function.identity())));
            if (!manageNodeIds.containsAll(userInfoList.stream().map(a -> a.getNodeId()).collect(Collectors.toSet()))) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u4eba\u5458\u65e0\u7ba1\u7406\u6743\u9650");
            }
        }
        if (CollectionUtils.isNotEmpty(existRules = this.queryRulesByDeptIdOrUserId(bizId, realDeptIds, userSimpleInfoMap.keySet()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u90e8\u95e8\u6216\u8005\u4eba\u5458\u4e0b\u5df2\u7ecf\u5b58\u5728\u914d\u7f6e");
        }
        ArrayList rules = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)realDeptIds)) {
            for (Long deptId : realDeptIds) {
                rules.add(this.buildRule(bizId, leadsTransferRulesAddReq, deptId, -1L));
            }
        }
        if (CollectionUtils.isNotEmpty(userSimpleInfoMap.keySet())) {
            for (Long userId : userSimpleInfoMap.keySet()) {
                rules.add(this.buildRule(bizId, leadsTransferRulesAddReq, ((UserSimpleInfo)userSimpleInfoMap.get(userId)).getNodeId(), userId));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            this.leadsTransferRulesMapper.insertBatch((List)rules);
        }
    }

    private LeadsTransferRules buildRule(Long bizId, LeadsTransferRulesAddReq leadsTransferRulesAddReq, Long deptId, Long userId) {
        LeadsTransferRules rule = (LeadsTransferRules)BeanUtil.convert((Object)leadsTransferRulesAddReq, LeadsTransferRules.class, (String[])new String[0]);
        rule.setBizId(bizId);
        rule.setNum(this.idGen.getNum());
        rule.setUserId(userId);
        rule.setDeptId(Long.valueOf(deptId == null ? -1L : deptId));
        rule.setCorpId(LoginUtils.getCurrentUserCorpId());
        rule.setCreateBy(LoginUtils.getCurrentUserId());
        rule.setUpdateBy(LoginUtils.getCurrentUserId());
        rule.setCreateTime(new Date());
        rule.setUpdateTime(new Date());
        return rule;
    }

    @Override
    public List<LeadsTransferRulesResp> list(Long bizId, LeadsTransferRulesListReq leadsTransferRulesListReq) {
        PageDto pageDto;
        log.info("query leads transfer rule with bizId={}, operatorId={}\uff0creq={}", new Object[]{bizId, LoginUtils.getCurrentUserId(), leadsTransferRulesListReq});
        ArrayList result = Lists.newArrayList();
        Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
        if (StringUtils.isNotBlank((CharSequence)leadsTransferRulesListReq.getDeptId())) {
            Long deptId = this.nodeService.getIdByNum(bizId, leadsTransferRulesListReq.getDeptId());
            if (!manageNodeIds.contains(deptId)) {
                return result;
            }
            manageNodeIds = Sets.newHashSet((Object[])new Long[]{deptId});
        }
        HashSet manageUserIds = Sets.newHashSet();
        if (leadsTransferRulesListReq.getUserId() != null) {
            manageUserIds = Sets.newHashSet((Object[])new Long[]{this.userService.getIdByNum(leadsTransferRulesListReq.getUserId())});
        }
        if ((pageDto = leadsTransferRulesListReq.getPageDto()) == null) {
            leadsTransferRulesListReq.setPageDto(new PageDto());
            pageDto = leadsTransferRulesListReq.getPageDto();
        }
        Long updateBy = null;
        if (StringUtils.isNotBlank((CharSequence)leadsTransferRulesListReq.getUpdateBy())) {
            updateBy = this.userService.getIdByNum(leadsTransferRulesListReq.getUpdateBy());
        }
        LeadsTransferRuleQueryDto queryDto = LeadsTransferRuleQueryDto.builder().bizId(bizId).deptIds(manageNodeIds).userIds((Set)manageUserIds).updateBy(updateBy).build();
        PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize());
        Page rules = this.leadsTransferRulesMapper.queryList(queryDto);
        pageDto.setCurPageCount(Integer.valueOf(rules.size()));
        pageDto.setCount(Integer.valueOf((int)rules.getTotal()));
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            HashSet deptIds = Sets.newHashSet();
            HashSet userIds = Sets.newHashSet();
            for (LeadsTransferRules rule2 : rules) {
                if (rule2.getDeptId() > 0L) {
                    deptIds.add(rule2.getDeptId());
                }
                if (rule2.getUserId() > 0L) {
                    userIds.add(rule2.getUserId());
                }
                userIds.add(rule2.getUpdateBy());
            }
            HashMap deptMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)deptIds)) {
                Map nodes = this.nodeService.getNodeByIds((Collection)deptIds, bizId);
                deptMap.putAll(nodes.values().stream().collect(Collectors.toMap(a -> a.getId(), a -> new StrIdAndNameDto(a.getNum(), a.getName()))));
            }
            HashMap userMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)userIds)) {
                List userInfoList = this.userService.getUserInfoByIds((Collection)userIds);
                userMap.putAll(userInfoList.stream().collect(Collectors.toMap(a -> a.getId(), a -> new StrIdAndNameDto(a.getNum(), a.getName()))));
            }
            rules.forEach(rule -> result.add(this.convertRule((LeadsTransferRules)rule, deptMap, userMap)));
        }
        return result;
    }

    private LeadsTransferRulesResp convertRule(LeadsTransferRules rule, Map<Long, StrIdAndNameDto> deptMap, Map<Long, StrIdAndNameDto> userMap) {
        LeadsTransferRulesResp resp = new LeadsTransferRulesResp();
        BeanUtils.copyProperties((Object)rule, (Object)resp);
        resp.setId(rule.getNum());
        resp.setDept(deptMap.get(rule.getDeptId()));
        resp.setUser(userMap.get(rule.getUserId()));
        resp.setUpdateBy(userMap.get(rule.getUpdateBy()));
        resp.setUpdateTime(rule.getUpdateTime());
        return resp;
    }

    private LeadsTransferRules getRuleWithCheckPermission(Long bizId, String num) {
        List<LeadsTransferRules> rules = this.getRulesWithCheckPermission(bizId, Lists.newArrayList((Object[])new String[]{num}));
        if (CollectionUtils.isNotEmpty(rules)) {
            return rules.get(0);
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d41\u8f6c\u53c2\u6570\u914d\u7f6e\u4e0d\u5b58\u5728");
    }

    private List<LeadsTransferRules> getRulesWithCheckPermission(Long bizId, List<String> nums) {
        List rules = this.leadsTransferRulesMapper.getByNums(bizId, nums);
        HashSet deptIds = Sets.newHashSet();
        for (LeadsTransferRules rule : rules) {
            deptIds.add(rule.getDeptId());
        }
        if (CollectionUtils.isNotEmpty((Collection)deptIds) && !this.userRoleCommonService.getManageNodeIds().containsAll(deptIds)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u90e8\u95e8\u65e0\u7ba1\u7406\u6743\u9650");
        }
        return rules;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mod(Long bizId, LeadsTransferRulesAddReq leadsTransferRulesAddReq) {
        log.info("mod leads transfer rule with bizId={}, operatorId={}, req={}", new Object[]{bizId, LoginUtils.getCurrentUserId(), leadsTransferRulesAddReq});
        leadsTransferRulesAddReq.commonValidate();
        LeadsTransferRules rule = this.getRuleWithCheckPermission(bizId, leadsTransferRulesAddReq.getId());
        BeanUtils.copyProperties((Object)leadsTransferRulesAddReq, (Object)rule, (String[])new String[]{"id"});
        rule.setUpdateBy(LoginUtils.getCurrentUserId());
        rule.setUpdateTime(new Date());
        this.leadsTransferRulesMapper.updateById((Object)rule);
    }

    @Override
    public Map<Long, LeadsTransferRules> getUserRuleMap(Long bizId, Collection<Long> userIds) {
        log.info("get user leads transfer rule list with bizId={}, userIds={}", (Object)bizId, userIds);
        if (CollectionUtils.isEmpty(userIds)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        List<LeadsTransferRules> rules = this.queryRulesByDeptIdOrUserId(bizId, null, userIds);
        rules.forEach(rule -> {
            this.hideSwitchOffConfig((LeadsTransferRules)rule);
            result.put(rule.getUserId(), rule);
        });
        Set haveRuleUserIds = rules.stream().map(a -> a.getUserId()).collect(Collectors.toSet());
        Set notHaveRuleUserIds = userIds.stream().filter(a -> !haveRuleUserIds.contains(a)).collect(Collectors.toSet());
        HashMap userId2DeptIdsMap = Maps.newHashMap();
        HashSet deptIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(notHaveRuleUserIds)) {
            List userInfoList = this.userService.getUserInfoByIds(notHaveRuleUserIds);
            for (UserSimpleInfo userInfo : userInfoList) {
                Node node = this.nodeService.getNode(userInfo.getNodeId(), bizId);
                List parentNodeIds = node.getIds();
                deptIds.addAll(parentNodeIds);
                Collections.reverse(parentNodeIds);
                userId2DeptIdsMap.put(userInfo.getId(), parentNodeIds);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)deptIds)) {
            HashMap deptId2RulesMap = Maps.newHashMap();
            List<LeadsTransferRules> deptRules = this.queryRulesByDeptIdOrUserId(bizId, deptIds, null);
            for (LeadsTransferRules rule2 : deptRules) {
                this.hideSwitchOffConfig(rule2);
                deptId2RulesMap.put(rule2.getDeptId(), rule2);
            }
            block2: for (Long userId : notHaveRuleUserIds) {
                List parentDeptIds = userId2DeptIdsMap.getOrDefault(userId, Lists.newArrayList());
                for (Long deptNodeId : parentDeptIds) {
                    if (!deptId2RulesMap.containsKey(deptNodeId)) continue;
                    result.put(userId, deptId2RulesMap.get(deptNodeId));
                    continue block2;
                }
            }
        }
        return result;
    }

    private void hideSwitchOffConfig(LeadsTransferRules rule) {
        if (rule == null) {
            return;
        }
        if (rule.getTempLibStagePeriodSwitch() != 1) {
            rule.setTempLibStagePeriod(Integer.valueOf(-1));
        }
        if (rule.getTempLibFollowPeriodSwitch() != 1) {
            rule.setTempLibFollowPeriod(Integer.valueOf(-1));
        }
        if (rule.getTempLibContractPeriodSwitch() != 1) {
            rule.setTempLibContractPeriod(Integer.valueOf(-1));
        }
        if (rule.getPrivateLibStagePeriodSwitch() != 1) {
            rule.setPrivateLibStagePeriod(Integer.valueOf(-1));
        }
        if (rule.getPrivateLibFollowPeriodSwitch() != 1) {
            rule.setPrivateLibFollowPeriod(Integer.valueOf(-1));
        }
        if (rule.getPrivateLibContractPeriodSwitch() != 1) {
            rule.setPrivateLibContractPeriod(Integer.valueOf(-1));
        }
        if (rule.getContractLibStagePeriodSwitch() != 1) {
            rule.setContractLibStagePeriod(Integer.valueOf(-1));
        }
        if (rule.getContractLibFollowPeriodSwitch() != 1) {
            rule.setContractLibFollowPeriod(Integer.valueOf(-1));
        }
        if (rule.getContractLibContractPeriodSwitch() != 1) {
            rule.setContractLibContractPeriod(Integer.valueOf(-1));
        }
    }

    private List<LeadsTransferRules> queryRulesByDeptIdOrUserId(Long bizId, Collection<Long> deptIds, Collection<Long> userIds) {
        ArrayList rules = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(deptIds)) {
            rules.addAll(this.leadsTransferRulesMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).in((Object)"dept_id", deptIds)).lt((Object)"user_id", (Object)0L)));
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            rules.addAll(this.leadsTransferRulesMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).in((Object)"user_id", userIds)));
        }
        return rules;
    }
}

