/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.impl;

import cn.kinyun.crm.common.dto.conf.LeadsConfBaseDto;
import cn.kinyun.crm.common.dto.conf.LeadsConfDetailDto;
import cn.kinyun.crm.common.dto.conf.LeadsConfDto;
import cn.kinyun.crm.common.dto.conf.LeadsConfExtend;
import cn.kinyun.crm.common.dto.conf.ProductLineDto;
import cn.kinyun.crm.common.enums.ConfigType;
import cn.kinyun.crm.common.enums.LeadsFieldSysEnum;
import cn.kinyun.crm.common.utils.IdGen;
import cn.kinyun.crm.dal.config.entity.LeadsConfig;
import cn.kinyun.crm.dal.config.entity.LeadsConfigDetail;
import cn.kinyun.crm.dal.config.entity.ProductLine;
import cn.kinyun.crm.dal.config.mapper.LeadsConfigDetailMapper;
import cn.kinyun.crm.dal.config.mapper.LeadsConfigMapper;
import cn.kinyun.crm.dal.leads.mapper.LeadsLibMapper;
import cn.kinyun.crm.sal.conf.service.LeadsConfService;
import cn.kinyun.crm.sal.conf.service.ProductLineService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.utils.LoginUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LeadsConfServiceImpl
implements LeadsConfService {
    @Autowired
    LeadsConfigMapper leadsConfigMapper;
    @Autowired
    LeadsConfigDetailMapper leadsConfigDetailMapper;
    @Autowired
    IdGen idGen;
    @Autowired
    ProductLineService productLineService;
    @Autowired
    ScrmUserService scrmUserService;
    @Autowired
    LeadsLibMapper leadsLibMapper;

    @Override
    public List<LeadsConfDto> listAll(Long bizId, String productLineNum) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineNum), (Object)"productLineNum is null!");
        ProductLine productLine = this.productLineService.getByNum(productLineNum);
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"product_line_id", (Object)productLine.getId()));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return this.listAllSys(bizId);
        }
        Map<Long, List<LeadsConfigDetail>> detailMap = this.getDetailMap(bizId, configs.stream().map(LeadsConfig::getId).collect(Collectors.toList()));
        Map userMap = this.scrmUserService.getNameByIds((Collection)configs.stream().map(LeadsConfig::getUpdateBy).collect(Collectors.toSet()));
        List result = configs.stream().map(leadsConfig -> {
            LeadsConfDto dto = this.build((LeadsConfig)leadsConfig);
            dto.setUpdateByName((String)userMap.get(leadsConfig.getUpdateBy()));
            dto.setProductLineNum(productLineNum);
            dto.setProductLineName(productLine.getName());
            return this.getLeadsConfDto(detailMap, (LeadsConfig)leadsConfig, dto);
        }).collect(Collectors.toList());
        List<LeadsConfDto> list = this.listAllSys(bizId);
        list.addAll(result);
        list.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return list;
    }

    private Map<Long, List<LeadsConfigDetail>> getDetailMap(Long bizId, List<Long> leadsConfIds) {
        if (CollectionUtils.isEmpty(leadsConfIds)) {
            return Maps.newHashMap();
        }
        List detailList = this.leadsConfigDetailMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"leads_config_id", leadsConfIds));
        return detailList.stream().collect(Collectors.groupingBy(LeadsConfigDetail::getLeadsConfigId));
    }

    @Override
    public List<LeadsConfDto> listAll(Long bizId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null!");
        List configs = this.leadsConfigMapper.selectList((Wrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return Lists.newArrayList();
        }
        Map<Long, List<LeadsConfigDetail>> detailMap = this.getDetailMap(bizId, configs.stream().map(LeadsConfig::getId).collect(Collectors.toList()));
        Map<Long, ProductLineDto> productLineDtoMap = this.productLineService.getProductMap();
        Map userMap = this.scrmUserService.getNameByIds((Collection)configs.stream().map(LeadsConfig::getUpdateBy).collect(Collectors.toSet()));
        List<LeadsConfDto> result = configs.stream().map(leadsConfig -> {
            LeadsConfDto dto = this.build((LeadsConfig)leadsConfig);
            dto.setUpdateByName((String)userMap.get(leadsConfig.getUpdateBy()));
            ProductLineDto productLineDto = (ProductLineDto)productLineDtoMap.get(leadsConfig.getProductLineId());
            if (productLineDto != null) {
                dto.setProductLineNum(productLineDto.getNum());
                dto.setProductLineName(productLineDto.getName());
            }
            return this.getLeadsConfDto(detailMap, (LeadsConfig)leadsConfig, dto);
        }).collect(Collectors.toList());
        result.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return result;
    }

    @Override
    public List<LeadsConfDto> listAllBase(Long bizId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null!");
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"config_type", (Object)ConfigType.BASE.getValue()));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return Lists.newArrayList();
        }
        Map userMap = this.scrmUserService.getNameByIds((Collection)configs.stream().map(LeadsConfig::getUpdateBy).collect(Collectors.toSet()));
        List<LeadsConfDto> result = configs.stream().map(leadsConfig -> {
            LeadsConfDto dto = this.build((LeadsConfig)leadsConfig);
            dto.setUpdateByName((String)userMap.get(leadsConfig.getUpdateBy()));
            return dto;
        }).collect(Collectors.toList());
        result.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return result;
    }

    @Override
    public List<LeadsConfDto> listAllBu(Long bizId, String productLineNum) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineNum), (Object)"productLineNum is null!");
        ProductLine productLine = this.productLineService.getByNum(productLineNum);
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"product_line_id", (Object)productLine.getId()));
        configs.addAll(this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"product_line_id", (Object)0L)).eq((Object)"config_type", (Object)ConfigType.BUSINESS.getValue())));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return Lists.newArrayList();
        }
        Map<Long, List<LeadsConfigDetail>> detailMap = this.getDetailMap(bizId, configs.stream().map(LeadsConfig::getId).collect(Collectors.toList()));
        Map userMap = this.scrmUserService.getNameByIds((Collection)configs.stream().map(LeadsConfig::getUpdateBy).collect(Collectors.toSet()));
        List<LeadsConfDto> result = configs.stream().map(leadsConfig -> {
            LeadsConfDto dto = this.build((LeadsConfig)leadsConfig);
            dto.setUpdateByName((String)userMap.get(leadsConfig.getUpdateBy()));
            dto.setProductLineNum(productLineNum);
            dto.setProductLineName(productLine.getName());
            return this.getLeadsConfDto(detailMap, (LeadsConfig)leadsConfig, dto);
        }).collect(Collectors.toList());
        result.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return result;
    }

    @Override
    public List<LeadsConfDto> listAllBu(Long bizId) {
        return this.listAll(bizId).stream().filter(leadsConfDto -> leadsConfDto.getConfigType() == ConfigType.BUSINESS.getValue()).collect(Collectors.toList());
    }

    @Override
    public List<LeadsConfDto> listAllSys(Long bizId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null!");
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"product_line_id", (Object)0L));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return Lists.newArrayList();
        }
        Map userMap = this.scrmUserService.getNameByIds((Collection)configs.stream().map(LeadsConfig::getUpdateBy).collect(Collectors.toSet()));
        List<LeadsConfDto> result = configs.stream().map(leadsConfig -> {
            LeadsConfDto dto = this.build((LeadsConfig)leadsConfig);
            dto.setUpdateByName((String)userMap.get(leadsConfig.getUpdateBy()));
            return dto;
        }).collect(Collectors.toList());
        result.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return result;
    }

    @Override
    public List<LeadsConfBaseDto> listAllEnable(Long bizId, String productLineNum) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineNum), (Object)"productNum is null");
        ProductLine productLine = this.productLineService.getByNum(productLineNum);
        return this.listAllEnable(bizId, productLine.getId());
    }

    @Override
    public List<LeadsConfBaseDto> listAllEnable(Long bizId, Long productLineId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((productLineId != null ? 1 : 0) != 0, (Object)"productLineId is null");
        List configs = this.leadsConfigMapper.queryList(bizId, productLineId, null, null, Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return Lists.newArrayList();
        }
        List<Long> configIds = configs.stream().map(LeadsConfig::getId).collect(Collectors.toList());
        Map<Long, List<LeadsConfigDetail>> detailMap = this.getDetailMap(bizId, configIds);
        List<LeadsConfBaseDto> businessDtos = configs.stream().map(leadsConfig -> {
            LeadsConfBaseDto dto = this.buildBase((LeadsConfig)leadsConfig);
            return this.getLeadsConfDto(detailMap, (LeadsConfig)leadsConfig, dto);
        }).collect(Collectors.toList());
        return businessDtos;
    }

    @Override
    public List<LeadsConfBaseDto> listEnableSys(Long bizId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"product_line_id", (Object)0L)).eq((Object)"is_enable", (Object)1));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return Lists.newArrayList();
        }
        List<LeadsConfBaseDto> businessDtos = configs.stream().map(leadsConfig -> this.buildBase((LeadsConfig)leadsConfig)).collect(Collectors.toList());
        businessDtos.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return businessDtos;
    }

    @Override
    public List<LeadsConfBaseDto> listEnableExtend(Long bizId, String productLineNum) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productLineNum), (Object)"productNum is null");
        ProductLine productLine = this.productLineService.getByNum(productLineNum);
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"config_type", (Object)ConfigType.BUSINESS.getValue())).eq((Object)"product_line_id", (Object)productLine.getId())).eq((Object)"is_enable", (Object)1));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return Lists.newArrayList();
        }
        Map<Long, List<LeadsConfigDetail>> detailMap = this.getDetailMap(bizId, configs.stream().map(LeadsConfig::getId).collect(Collectors.toList()));
        List<LeadsConfBaseDto> businessDtos = configs.stream().map(leadsConfig -> {
            LeadsConfBaseDto dto = this.buildBase((LeadsConfig)leadsConfig);
            return this.getLeadsConfDto(detailMap, (LeadsConfig)leadsConfig, dto);
        }).collect(Collectors.toList());
        businessDtos.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return businessDtos;
    }

    @Override
    public List<LeadsConfBaseDto> listEnableBu(Long bizId, Long productLineId) {
        List<Object> list = this.listAllEnable(bizId, productLineId);
        list = list.stream().filter(leadsConfBaseDto -> leadsConfBaseDto.getConfigType() == ConfigType.BUSINESS.getValue()).collect(Collectors.toList());
        list.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return list;
    }

    @Override
    public String add(Long bizId, LeadsConfDto leadsConfDto) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)leadsConfDto.getName()), (Object)"\u540d\u79f0\u4e3a\u7a7a");
        Preconditions.checkArgument((leadsConfDto.getConfigType() == 1 ? 1 : 0) != 0, (Object)"\u53ea\u80fd\u65b0\u589e\u4e1a\u52a1\u5b57\u6bb5");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)leadsConfDto.getProductLineNum()), (Object)"\u9500\u552e\u7ebf\u4e0d\u80fd\u4e3a\u7a7a");
        if (leadsConfDto.getType() == 4 || leadsConfDto.getType() == 5) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)leadsConfDto.getDetails()), (Object)"\u5b57\u6bb5\u9009\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long productLineId = StringUtils.isNotBlank((CharSequence)leadsConfDto.getProductLineNum()) ? this.productLineService.getProductLineId(leadsConfDto.getProductLineNum()) : null;
        this.nameExists(leadsConfDto.getNum(), leadsConfDto.getName(), LoginUtils.getCurrentUserBizId(), productLineId);
        Integer maxSeq = this.leadsConfigMapper.getMaxSeq(bizId);
        maxSeq = maxSeq != null ? maxSeq + 1 : 1;
        LeadsConfig config = LeadsConfig.builder().bizId(LoginUtils.getCurrentUserBizId()).corpId(LoginUtils.getCurrentUserCorpId()).configType(Integer.valueOf(leadsConfDto.getConfigType())).name(leadsConfDto.getName()).productLineId(Long.valueOf(productLineId != null ? productLineId : 0L)).isSystem(Integer.valueOf(0)).seq(maxSeq).editable(Integer.valueOf(1)).num(this.idGen.getNum()).type(Integer.valueOf(leadsConfDto.getType())).isEnable(Integer.valueOf(leadsConfDto.getIsEnable())).isRequired(Integer.valueOf(leadsConfDto.getIsRequired())).fieldName(this.getExtendFieldName(leadsConfDto.getConfigType(), bizId, productLineId)).createBy(LoginUtils.getCurrentUserId()).updateBy(LoginUtils.getCurrentUserId()).createTime(new Date()).updateTime(new Date()).build();
        this.leadsConfigMapper.insert((Object)config);
        this.addDetails(leadsConfDto.getDetails(), config.getId());
        return config.getNum();
    }

    private void addDetails(List<LeadsConfDetailDto> detailDtos, Long confId) {
        if (CollectionUtils.isNotEmpty(detailDtos)) {
            int i = 1;
            for (LeadsConfDetailDto confDetailDto : detailDtos) {
                LeadsConfigDetail detail = LeadsConfigDetail.builder().leadsConfigId(confId).num(this.idGen.getNum()).seq(Integer.valueOf(i++)).name(confDetailDto.getName()).bizId(LoginUtils.getCurrentUserBizId()).corpId(LoginUtils.getCurrentUserCorpId()).createBy(LoginUtils.getCurrentUserId()).updateBy(LoginUtils.getCurrentUserId()).createTime(new Date()).updateTime(new Date()).build();
                this.leadsConfigDetailMapper.insert((Object)detail);
            }
        }
    }

    private String getExtendFieldName(int configType, Long bizId, Long productLineId) {
        ArrayList allExtends = Lists.newArrayList((Iterable)LeadsConfExtend.extendFields);
        List<String> used = configType == 0 ? this.getExtendFieldName(bizId) : this.getExtendFieldName(bizId, productLineId);
        allExtends.removeAll(used);
        if (CollectionUtils.isEmpty((Collection)allExtends)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6269\u5c55\u5b57\u6bb5\u5df2\u7528\u51c0");
        }
        return configType == 0 ? (String)allExtends.get(0) : (String)allExtends.get(allExtends.size() - 1);
    }

    @Override
    public String mod(Long bizId, LeadsConfDto leadsConfDto) {
        Preconditions.checkArgument((leadsConfDto.getNum() != null ? 1 : 0) != 0, (Object)"\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LeadsConfig leadsConfig = (LeadsConfig)this.leadsConfigMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"num", (Object)leadsConfDto.getNum()));
        if (leadsConfig == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        if (leadsConfig.getIsSystem().equals(1)) {
            if (leadsConfig.getEditable().equals(0)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672c\u5b57\u6bb5\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
            leadsConfig.setIsRequired(Integer.valueOf(leadsConfDto.getIsRequired()));
            leadsConfig.setIsEnable(Integer.valueOf(leadsConfDto.getIsEnable()));
            leadsConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            leadsConfig.setUpdateTime(new Date());
            this.leadsConfigMapper.updateById((Object)leadsConfig);
        } else {
            if (leadsConfDto.getConfigType() == 1) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)leadsConfDto.getProductLineNum()), (Object)"\u9500\u552e\u7ebf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (leadsConfDto.getType() == 4 || leadsConfDto.getType() == 5) {
                Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)leadsConfDto.getDetails()), (Object)"\u5b57\u6bb5\u9009\u9879\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.leadsConfigDetailMapper.delete((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"leads_config_id", (Object)leadsConfig.getId()));
            this.nameExists(leadsConfDto.getNum(), leadsConfDto.getName(), leadsConfig.getBizId(), leadsConfig.getProductLineId());
            leadsConfig.setIsRequired(Integer.valueOf(leadsConfDto.getIsRequired()));
            leadsConfig.setIsEnable(Integer.valueOf(leadsConfDto.getIsEnable()));
            leadsConfig.setType(Integer.valueOf(leadsConfDto.getType()));
            leadsConfig.setName(leadsConfDto.getName());
            leadsConfig.setUpdateBy(LoginUtils.getCurrentUserId());
            leadsConfig.setUpdateTime(new Date());
            this.leadsConfigMapper.updateById((Object)leadsConfig);
            this.addDetails(leadsConfDto.getDetails(), leadsConfig.getId());
        }
        return leadsConfig.getNum();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sort(Long bizId, Integer configType, List<String> nums) {
        if (configType.intValue() == ConfigType.BASE.getValue()) {
            Map configsMap = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"config_type", (Object)ConfigType.BASE.getValue())).stream().collect(Collectors.toMap(LeadsConfig::getNum, Function.identity()));
            int seq = 0;
            for (String num : nums) {
                LeadsConfig leadsConfig = (LeadsConfig)configsMap.get(num);
                leadsConfig.setSeq(Integer.valueOf(seq++));
                this.leadsConfigMapper.updateById((Object)leadsConfig);
            }
        } else {
            Map configsMap = this.leadsConfigMapper.selectList((Wrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).stream().collect(Collectors.toMap(LeadsConfig::getNum, Function.identity()));
            int seq = 20;
            for (String num : nums) {
                LeadsConfig leadsConfig = (LeadsConfig)configsMap.get(num);
                leadsConfig.setSeq(Integer.valueOf(seq++));
                this.leadsConfigMapper.updateById((Object)leadsConfig);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String num) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LeadsConfig leadsConfig = (LeadsConfig)this.leadsConfigMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"num", (Object)num));
        if (leadsConfig == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        if (leadsConfig.getIsSystem().equals(1)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7cfb\u7edf\u5185\u7f6e\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.leadsConfigMapper.deleteById((Serializable)leadsConfig.getId());
        this.leadsConfigDetailMapper.delete((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)LoginUtils.getCurrentUserBizId())).eq((Object)"leads_config_id", (Object)leadsConfig.getId()));
    }

    private void nameExists(String num, String name, Long bizId, Long productLineId) {
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"product_line_id", (Object)productLineId)).eq((Object)"name", (Object)name));
        if (CollectionUtils.isNotEmpty(configs = configs.stream().filter(leadsConfig -> !leadsConfig.getNum().equals(num)).collect(Collectors.toList()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u540d\u5df2\u5b58\u5728");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void init() {
        List<LeadsConfig> configs = this.loadFromEnum();
        configs.stream().forEach(config -> this.leadsConfigMapper.insert(config));
    }

    private List<String> getExtendFieldName(Long bizId, Long productLineId) {
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"config_type", (Object)ConfigType.BASE.getValue())).eq((Object)"is_system", (Object)0));
        configs.addAll(this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"config_type", (Object)ConfigType.BUSINESS.getValue())).eq((Object)"product_line_id", (Object)productLineId)).eq((Object)"is_system", (Object)0)));
        return configs.stream().map(LeadsConfig::getFieldName).collect(Collectors.toList());
    }

    private List<String> getExtendFieldName(Long bizId) {
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"is_system", (Object)0));
        return configs.stream().map(LeadsConfig::getFieldName).collect(Collectors.toList());
    }

    @Override
    public List<LeadsConfBaseDto> listUnEnableExtend(Long bizId, Long productLineId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((productLineId != null ? 1 : 0) != 0, (Object)"productLineId is null");
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"config_type", (Object)ConfigType.BUSINESS.getValue())).eq((Object)"product_line_id", (Object)productLineId)).eq((Object)"is_enable", (Object)0)).eq((Object)"is_system", (Object)0));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return Lists.newArrayList();
        }
        List<LeadsConfBaseDto> businessDtos = configs.stream().map(leadsConfig -> this.buildBase((LeadsConfig)leadsConfig)).collect(Collectors.toList());
        businessDtos.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return businessDtos;
    }

    @Override
    public List<LeadsConfBaseDto> listUnEnableSys(Long bizId) {
        List configs = this.leadsConfigMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"is_enable", (Object)0)).eq((Object)"is_system", (Object)1));
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return Lists.newArrayList();
        }
        List<LeadsConfBaseDto> businessDtos = configs.stream().map(leadsConfig -> this.buildBase((LeadsConfig)leadsConfig)).collect(Collectors.toList());
        businessDtos.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        return businessDtos;
    }

    private LeadsConfBaseDto buildBase(LeadsConfig leadsConfig) {
        return LeadsConfBaseDto.builder().fieldName(leadsConfig.getFieldName()).name(leadsConfig.getName()).type(leadsConfig.getType().intValue()).isRequired(leadsConfig.getIsRequired().intValue()).configType(leadsConfig.getConfigType().intValue()).seq(leadsConfig.getSeq().intValue()).build();
    }

    private LeadsConfDto build(LeadsConfig leadsConfig) {
        LeadsConfDto dto = LeadsConfDto.builder().editable(leadsConfig.getEditable().intValue()).isSystem(leadsConfig.getIsSystem().intValue()).updateTime(Long.valueOf(leadsConfig.getUpdateTime().getTime())).fieldName(leadsConfig.getFieldName()).name(leadsConfig.getName()).num(leadsConfig.getNum()).type(leadsConfig.getType().intValue()).seq(leadsConfig.getSeq().intValue()).isRequired(leadsConfig.getIsRequired().intValue()).configType(leadsConfig.getConfigType().intValue()).isEnable(leadsConfig.getIsEnable().intValue()).build();
        return dto;
    }

    private LeadsConfDto getLeadsConfDto(Map<Long, List<LeadsConfigDetail>> detailMap, LeadsConfig leadsConfig, LeadsConfDto dto) {
        List<LeadsConfigDetail> details = detailMap.get(leadsConfig.getId());
        if (CollectionUtils.isNotEmpty(details)) {
            details.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
            dto.setDetails(details.stream().map(detail -> LeadsConfDetailDto.builder().seq(detail.getSeq().intValue()).name(detail.getName()).build()).collect(Collectors.toList()));
        }
        return dto;
    }

    private LeadsConfBaseDto getLeadsConfDto(Map<Long, List<LeadsConfigDetail>> detailMap, LeadsConfig leadsConfig, LeadsConfBaseDto dto) {
        List<LeadsConfigDetail> details = detailMap.get(leadsConfig.getId());
        if (CollectionUtils.isNotEmpty(details)) {
            details.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
            dto.setDetails(details.stream().map(detail -> LeadsConfDetailDto.builder().seq(detail.getSeq().intValue()).name(detail.getName()).build()).collect(Collectors.toList()));
        }
        return dto;
    }

    private List<LeadsConfig> loadFromEnum() {
        ArrayList configs = Lists.newArrayList();
        for (LeadsFieldSysEnum fieldSysEnum : LeadsFieldSysEnum.values()) {
            if (fieldSysEnum.getConfigType() != ConfigType.BASE.getValue() && fieldSysEnum.getConfigType() != ConfigType.BUSINESS.getValue()) continue;
            configs.add(LeadsConfig.builder().fieldName(fieldSysEnum.getFieldName()).name(fieldSysEnum.getName()).editable(Integer.valueOf(fieldSysEnum.getEditable() ? 1 : 0)).configType(Integer.valueOf(fieldSysEnum.getConfigType())).type(Integer.valueOf(0)).seq(fieldSysEnum.getSeq()).productLineId(Long.valueOf(0L)).isRequired(Integer.valueOf(1)).isEnable(Integer.valueOf(1)).num(this.idGen.getNum()).bizId(LoginUtils.getCurrentUserBizId()).corpId(LoginUtils.getCurrentUserCorpId()).isSystem(Integer.valueOf(1)).createBy(LoginUtils.getCurrentUserId()).updateBy(LoginUtils.getCurrentUserId()).createTime(new Date()).updateTime(new Date()).build());
        }
        return configs;
    }
}

