/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.impl;

import cn.kinyun.crm.common.dto.StrIdAndNameDto;
import cn.kinyun.crm.common.dto.conf.AllocRuleMatchResult;
import cn.kinyun.crm.common.dto.conf.LeadsConfDto;
import cn.kinyun.crm.common.dto.conf.ProductLineDto;
import cn.kinyun.crm.common.dto.conf.req.AllocRuleReqDto;
import cn.kinyun.crm.common.dto.conf.req.RuleSortReq;
import cn.kinyun.crm.common.dto.conf.resp.AllocRuleRespDto;
import cn.kinyun.crm.common.enums.AllocAimType;
import cn.kinyun.crm.common.enums.LeadsFieldSysEnum;
import cn.kinyun.crm.common.utils.IdGen;
import cn.kinyun.crm.dal.config.entity.LeadsAllocRules;
import cn.kinyun.crm.dal.config.mapper.LeadsAllocRulesMapper;
import cn.kinyun.crm.dal.leads.entity.LeadsLib;
import cn.kinyun.crm.dal.leads.entity.LeadsTag;
import cn.kinyun.crm.dal.leads.mapper.LeadsLibMapper;
import cn.kinyun.crm.dal.leads.mapper.LeadsTagMapper;
import cn.kinyun.crm.sal.conf.service.LeadsAllocRuleService;
import cn.kinyun.crm.sal.conf.service.LeadsConfService;
import cn.kinyun.crm.sal.conf.service.ProductLineService;
import cn.kinyun.crm.sal.conf.service.RuleMatchService;
import cn.kinyun.crm.sal.conf.service.SysConfigService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.service.AreaService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmChannelService;
import com.kuaike.scrm.common.service.ScrmStageService;
import com.kuaike.scrm.common.service.ScrmTagService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.ChannelDto;
import com.kuaike.scrm.common.service.dto.resp.StageDto;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LeadsAllocRuleServiceImpl
implements LeadsAllocRuleService {
    @Autowired
    ProductLineService productLineService;
    @Autowired
    IdGen idGen;
    @Autowired
    LeadsAllocRulesMapper leadsAllocRulesMapper;
    @Autowired
    LeadsConfService leadsConfService;
    @Autowired
    ScrmUserService scrmUserService;
    @Autowired
    NodeService nodeService;
    @Autowired
    ScrmChannelService scrmChannelService;
    @Autowired
    ScrmStageService scrmStageService;
    @Autowired
    ScrmTagService scrmTagService;
    @Autowired
    AreaService areaService;
    @Autowired
    LeadsLibMapper leadsLibMapper;
    @Autowired
    LeadsTagMapper leadsTagMapper;
    @Autowired
    RuleMatchService ruleMatchService;
    @Autowired
    SysConfigService sysConfigService;

    @Override
    public String add(Long bizId, AllocRuleReqDto allocRuleReqDto) {
        allocRuleReqDto.checkAdd();
        LeadsAllocRules rule = LeadsAllocRules.builder().num(this.idGen.getNum()).allocMode(Integer.valueOf(allocRuleReqDto.getAllocMode())).logic(Integer.valueOf(allocRuleReqDto.getLogic())).provinceId(allocRuleReqDto.getProvinceId()).cityId(allocRuleReqDto.getCityId()).productLineId(this.productLineService.getProductLineId(allocRuleReqDto.getProductLineNum())).enable(Integer.valueOf(1)).bizId(LoginUtils.getCurrentUserBizId()).corpId(LoginUtils.getCurrentUserCorpId()).createBy(LoginUtils.getCurrentUserId()).updateBy(LoginUtils.getCurrentUserId()).createTime(new Date()).updateTime(new Date()).isDeleted(Integer.valueOf(0)).build();
        Integer maxSeq = this.leadsAllocRulesMapper.getMaxSeq(bizId);
        maxSeq = maxSeq != null ? maxSeq + 1 : 0;
        rule.setSeq(maxSeq);
        this.fillExpressionAndMemberInfo(bizId, allocRuleReqDto.getProductLineNum(), rule, allocRuleReqDto.getMemberIds(), allocRuleReqDto.getMemberType(), allocRuleReqDto.getExpressionList());
        this.leadsAllocRulesMapper.insert((Object)rule);
        return rule.getNum();
    }

    @Override
    public String mod(Long bizId, AllocRuleReqDto allocRuleReqDto) {
        allocRuleReqDto.checkMod();
        LeadsAllocRules existRule = (LeadsAllocRules)this.leadsAllocRulesMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)allocRuleReqDto.getNum()));
        if (existRule == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u627e\u5230\u89c4\u5219\u914d\u7f6e");
        }
        existRule.setAllocMode(Integer.valueOf(allocRuleReqDto.getAllocMode()));
        existRule.setLogic(Integer.valueOf(allocRuleReqDto.getLogic()));
        existRule.setProvinceId(allocRuleReqDto.getProvinceId());
        existRule.setCityId(allocRuleReqDto.getCityId());
        existRule.setEnable(Integer.valueOf(1));
        existRule.setProductLineId(this.productLineService.getProductLineId(allocRuleReqDto.getProductLineNum()));
        this.fillExpressionAndMemberInfo(bizId, allocRuleReqDto.getProductLineNum(), existRule, allocRuleReqDto.getMemberIds(), allocRuleReqDto.getMemberType(), allocRuleReqDto.getExpressionList());
        existRule.setUpdateBy(LoginUtils.getCurrentUserId());
        existRule.setUpdateTime(new Date());
        this.leadsAllocRulesMapper.updateById((Object)existRule);
        return existRule.getNum();
    }

    @Override
    public void delete(Long bizId, String num) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"num is null");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        LeadsAllocRules existRule = (LeadsAllocRules)this.leadsAllocRulesMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)num));
        if (existRule == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u627e\u5230\u89c4\u5219\u914d\u7f6e");
        }
        this.leadsAllocRulesMapper.deleteById((Serializable)existRule.getId());
    }

    @Override
    public void enable(Long bizId, String num) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"num is null");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        LeadsAllocRules existRule = (LeadsAllocRules)this.leadsAllocRulesMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)num));
        if (existRule == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u627e\u5230\u89c4\u5219\u914d\u7f6e");
        }
        existRule.setEnable(Integer.valueOf(1));
        existRule.setUpdateBy(LoginUtils.getCurrentUserId());
        existRule.setUpdateTime(new Date());
        this.leadsAllocRulesMapper.updateById((Object)existRule);
    }

    @Override
    public void unEnable(Long bizId, String num) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"num is null");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        LeadsAllocRules existRule = (LeadsAllocRules)this.leadsAllocRulesMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)num));
        if (existRule == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u627e\u5230\u89c4\u5219\u914d\u7f6e");
        }
        existRule.setEnable(Integer.valueOf(0));
        existRule.setUpdateBy(LoginUtils.getCurrentUserId());
        existRule.setUpdateTime(new Date());
        this.leadsAllocRulesMapper.updateById((Object)existRule);
    }

    @Override
    public List<AllocRuleRespDto> list(Long bizId) {
        List rulesList = this.leadsAllocRulesMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId));
        rulesList.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        Map<Long, ProductLineDto> productLineDtoMap = this.productLineService.getProductMap();
        ArrayList result = Lists.newArrayList();
        Map userNameMap = this.scrmUserService.getNameByIds((Collection)rulesList.stream().map(LeadsAllocRules::getUpdateBy).collect(Collectors.toList()));
        for (LeadsAllocRules rule : rulesList) {
            AllocRuleRespDto respDto = AllocRuleRespDto.builder().num(rule.getNum()).allocMode(rule.getAllocMode().intValue()).enable(rule.getEnable().intValue()).logic(rule.getLogic().intValue()).provinceId(rule.getProvinceId()).cityId(rule.getCityId()).updateTime(Long.valueOf(rule.getUpdateTime().getTime())).memberType(rule.getMemberType().intValue()).expressionList(JSONObject.parseArray((String)rule.getExpression(), AllocRuleRespDto.ExpressionRespDto.class)).memberList(JSONObject.parseArray((String)rule.getAllocMemberInfo(), StrIdAndNameDto.class)).updateByName((String)userNameMap.get(rule.getUpdateBy())).seq(rule.getSeq()).build();
            if (rule.getProvinceId() != null) {
                respDto.setProvinceName(this.areaService.getName(rule.getProvinceId()));
            }
            if (rule.getCityId() != null) {
                respDto.setCityName(this.areaService.getName(rule.getCityId()));
            }
            ProductLineDto productLineDto = productLineDtoMap.get(rule.getProductLineId());
            respDto.setProductLine(new StrIdAndNameDto(productLineDto.getNum(), productLineDto.getName()));
            result.add(respDto);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private AllocRuleRespDto.ExpressionRespDto fillDesc(AllocRuleReqDto.ExpressionReqDto reqDto, Map<String, LeadsConfDto> leadsConfMap) {
        AllocRuleRespDto.ExpressionRespDto respDto;
        block21: {
            LeadsConfDto leadsConfBaseDto;
            block22: {
                block23: {
                    leadsConfBaseDto = leadsConfMap.get(reqDto.getFieldName());
                    respDto = new AllocRuleRespDto.ExpressionRespDto();
                    respDto.setFieldName(reqDto.getFieldName());
                    respDto.setOp(reqDto.getOp());
                    respDto.setType(reqDto.getType());
                    if (leadsConfBaseDto != null && leadsConfBaseDto.getIsEnable() != 0) break block22;
                    if (!reqDto.getFieldName().equals("channelId")) break block23;
                    respDto.setName("\u6e20\u9053");
                    break block21;
                }
                if (reqDto.getFieldName().equals("stageId")) {
                    respDto.setName("\u9636\u6bb5");
                    break block21;
                } else if (reqDto.getFieldName().equals("tagIds")) {
                    respDto.setName("\u5ba2\u6237\u6807\u7b7e");
                    break block21;
                } else {
                    if (leadsConfBaseDto != null) {
                        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, String.format("\u5b57\u6bb5\u201d%s\u201c\u5df2\u5220\u9664\u6216\u8005\u5173\u95ed", leadsConfBaseDto.getName()));
                    }
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, String.format("\u5b57\u6bb5\u201d%s\u201c\u672a\u627e\u5230", reqDto.getFieldName()));
                }
            }
            respDto.setName(leadsConfBaseDto.getName());
        }
        if (reqDto.getFieldName().equals(LeadsFieldSysEnum.MARKET_USER_ID.getFieldName())) {
            if (reqDto.getValue() != null) {
                String userNO = String.valueOf(reqDto.getValue());
                List userSimpleInfoList = this.scrmUserService.getUserInfoByNums((Collection)Lists.newArrayList((Object[])new String[]{userNO}));
                if (CollectionUtils.isEmpty((Collection)userSimpleInfoList)) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
                }
                UserSimpleInfo userSimpleInfo = (UserSimpleInfo)userSimpleInfoList.get(0);
                respDto.setValue((Object)userSimpleInfo);
                return respDto;
            }
            if (reqDto.getValues() == null) return respDto;
            List userNos = JSONArray.parseArray((String)JSONObject.toJSONString((Object)reqDto.getValues()), String.class);
            List userSimpleInfoList = this.scrmUserService.getUserInfoByNums((Collection)userNos);
            if (CollectionUtils.isEmpty((Collection)userSimpleInfoList)) throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7528\u6237\u4fe1\u606f\u4e0d\u6b63\u786e");
            if (userSimpleInfoList.size() < respDto.getValues().size()) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7528\u6237\u4fe1\u606f\u4e0d\u6b63\u786e");
            }
            respDto.setValues(userSimpleInfoList);
            return respDto;
        }
        if (reqDto.getFieldName().equals(LeadsFieldSysEnum.AREA_ID.getFieldName()) || LeadsFieldSysEnum.AREA_ID.getRelateFields().contains(reqDto.getFieldName())) {
            if (reqDto.getValue() != null) {
                String areaId = String.valueOf(reqDto.getValue());
                respDto.setValue((Object)new StrIdAndNameDto(areaId, this.areaService.getName(areaId)));
                return respDto;
            }
            if (!CollectionUtils.isNotEmpty((Collection)reqDto.getValues())) return respDto;
            List areaIds = JSONArray.parseArray((String)JSONObject.toJSONString((Object)reqDto.getValues()), String.class);
            Map nameMap = this.areaService.getNames((Collection)areaIds);
            respDto.setValues((List)Lists.newArrayList());
            Iterator userSimpleInfo = areaIds.iterator();
            while (userSimpleInfo.hasNext()) {
                String areaId = (String)userSimpleInfo.next();
                respDto.getValues().add(new StrIdAndNameDto(areaId, (String)nameMap.get(areaId)));
            }
            return respDto;
        }
        if (reqDto.getFieldName().equals("channelId")) {
            if (reqDto.getValue() != null) {
                String channelId = String.valueOf(reqDto.getValue());
                ChannelDto channelDto = this.scrmChannelService.getByNum(LoginUtils.getCurrentUserBizId(), channelId);
                respDto.setValue((Object)channelDto);
                return respDto;
            }
            if (!CollectionUtils.isNotEmpty((Collection)reqDto.getValues())) return respDto;
            List channelIds = JSONArray.parseArray((String)JSONObject.toJSONString((Object)reqDto.getValues()), Long.class);
            respDto.setValues((List)Lists.newArrayList());
            Iterator channelDto = channelIds.iterator();
            while (channelDto.hasNext()) {
                Long channelId = (Long)channelDto.next();
                ChannelDto channelDto2 = this.scrmChannelService.getById(LoginUtils.getCurrentUserBizId(), channelId);
                respDto.getValues().add(channelDto2);
            }
            return respDto;
        }
        if (reqDto.getFieldName().equals("stageId")) {
            if (reqDto.getValue() != null) {
                Long stageId = Long.parseLong(String.valueOf(reqDto.getValue()));
                StageDto stageDto = this.scrmStageService.getById(LoginUtils.getCurrentUserBizId(), stageId);
                respDto.setValue((Object)stageDto);
                return respDto;
            }
            if (!CollectionUtils.isNotEmpty((Collection)reqDto.getValues())) return respDto;
            List stageIds = JSONArray.parseArray((String)JSONObject.toJSONString((Object)reqDto.getValues()), Long.class);
            respDto.setValues((List)Lists.newArrayList());
            Iterator stageDto = stageIds.iterator();
            while (stageDto.hasNext()) {
                Long stageId = (Long)stageDto.next();
                StageDto stageDto2 = this.scrmStageService.getById(LoginUtils.getCurrentUserBizId(), stageId);
                respDto.getValues().add(stageDto2);
            }
            return respDto;
        }
        if (!reqDto.getFieldName().equals("tagIds")) {
            respDto.setValue(reqDto.getValue());
            respDto.setValues(reqDto.getValues());
            return respDto;
        }
        if (reqDto.getValue() != null) {
            String tagId = String.valueOf(reqDto.getValue());
            Map nameMap = this.scrmTagService.getNameByIds(LoginUtils.getCurrentUserCorpId(), (Collection)Lists.newArrayList((Object[])new String[]{tagId}));
            respDto.setValue((Object)new StrIdAndNameDto(tagId, (String)nameMap.get(tagId)));
            return respDto;
        }
        if (!CollectionUtils.isNotEmpty((Collection)reqDto.getValues())) return respDto;
        List tagIds = JSONArray.parseArray((String)JSONObject.toJSONString((Object)reqDto.getValues()), String.class);
        Map nameMap = this.scrmTagService.getNameByIds(LoginUtils.getCurrentUserCorpId(), (Collection)tagIds);
        respDto.setValues((List)Lists.newArrayList());
        Iterator iterator = tagIds.iterator();
        while (iterator.hasNext()) {
            String tagId = (String)iterator.next();
            respDto.getValues().add(new StrIdAndNameDto(tagId, (String)nameMap.get(tagId)));
        }
        return respDto;
    }

    private void fillExpressionAndMemberInfo(Long bizId, String productLineNum, LeadsAllocRules rules, List<String> memberIds, int memberType, List<AllocRuleReqDto.ExpressionReqDto> expressionReqDtoList) {
        ArrayList expressionRespDtos = Lists.newArrayList();
        Map<String, LeadsConfDto> leadsConfMap = this.leadsConfService.listAll(bizId, productLineNum).stream().collect(Collectors.toMap(LeadsConfDto::getFieldName, Function.identity()));
        if (CollectionUtils.isNotEmpty(expressionReqDtoList)) {
            for (AllocRuleReqDto.ExpressionReqDto expressionReqDto : expressionReqDtoList) {
                expressionRespDtos.add(this.fillDesc(expressionReqDto, leadsConfMap));
            }
        }
        rules.setExpression(JSONObject.toJSONString((Object)expressionRespDtos));
        rules.setMemberType(Integer.valueOf(memberType));
        if (memberType == AllocAimType.USER.getValue()) {
            rules.setAllocMemberInfo(JSONObject.toJSONString(this.scrmUserService.getUserInfoByNums(memberIds).stream().map(user -> new StrIdAndNameDto(user.getNum(), user.getName())).collect(Collectors.toList())));
        } else {
            Map numIdMap = this.nodeService.getIdByNums(bizId, memberIds);
            Map nameMap = this.nodeService.getFullNameByIds(bizId, numIdMap.values());
            rules.setAllocMemberInfo(JSONObject.toJSONString(memberIds.stream().map(memberId -> new StrIdAndNameDto(memberId, (String)nameMap.get(numIdMap.get(memberId)))).collect(Collectors.toList())));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sort(Long bizId, RuleSortReq sortReq) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)sortReq.getRuleNums()), (Object)"\u89c4\u5219\u7f16\u53f7\u4e3a\u7a7a");
        List rulesList = this.leadsAllocRulesMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId));
        Preconditions.checkArgument((rulesList.size() == sortReq.getRuleNums().size() ? 1 : 0) != 0, (Object)"\u89c4\u5219\u6570\u91cf\u4e0d\u5339\u914d");
        Map ruleMap = rulesList.stream().collect(Collectors.toMap(LeadsAllocRules::getNum, Function.identity()));
        int seq = 0;
        for (String ruleNum : sortReq.getRuleNums()) {
            LeadsAllocRules rules = (LeadsAllocRules)ruleMap.get(ruleNum);
            if (rules == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u627e\u5230\u89c4\u5219");
            }
            rules.setSeq(Integer.valueOf(seq++));
            rules.setUpdateBy(LoginUtils.getCurrentUserId());
            rules.setUpdateTime(new Date());
            this.leadsAllocRulesMapper.updateById((Object)rules);
        }
    }

    @Override
    public AllocRuleMatchResult matchAllocRules(Long bizId, Long leadsId) {
        LeadsLib leadsLib = (LeadsLib)this.leadsLibMapper.selectById((Serializable)leadsId);
        List<String> tagIds = Collections.emptyList();
        List tagList = this.leadsTagMapper.getByLeasIds(LoginUtils.getCurrentUserBizId(), Collections.singleton(leadsId));
        if (CollectionUtils.isNotEmpty((Collection)tagList)) {
            tagIds = tagList.stream().map(LeadsTag::getTagId).collect(Collectors.toList());
        }
        return this.ruleMatchService.matchAllocRules(bizId, leadsLib, tagIds);
    }
}

