/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.impl;

import cn.kinyun.crm.common.service.CrmProductLineService;
import cn.kinyun.crm.common.service.dto.resp.CrmProductLineResp;
import cn.kinyun.crm.dal.config.entity.ProductLine;
import cn.kinyun.crm.dal.config.mapper.ProductLineMapper;
import cn.kinyun.crm.dal.util.BizTableContext;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmProductLineServiceImpl
implements CrmProductLineService {
    private static final Logger log = LoggerFactory.getLogger(CrmProductLineServiceImpl.class);
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private ProductLineMapper productLineMapper;

    public List<CrmProductLineResp> getListByBizId(Long bizId) {
        BizTableContext.putBizId((Long)bizId);
        BizSimpleDto biz = this.scrmBizService.getById(bizId);
        Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Preconditions.checkArgument((biz.getIsOpenCrm() != null && biz.getIsOpenCrm() != 0 ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u672a\u5f00\u901aCRM\u529f\u80fd");
        List list = this.productLineMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"is_deleted", (Object)0));
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("product line not found, bizId={}", (Object)bizId);
            return Collections.emptyList();
        }
        ArrayList<CrmProductLineResp> result = new ArrayList<CrmProductLineResp>(list.size());
        for (ProductLine it : list) {
            CrmProductLineResp dto = this.newCrmProductLineResp(it);
            result.add(dto);
        }
        return result;
    }

    public CrmProductLineResp getByNum(Long bizId, String num) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u7f16\u53f7\u4e3a\u7a7a");
        BizTableContext.putBizId((Long)bizId);
        BizSimpleDto biz = this.scrmBizService.getById(bizId);
        Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Preconditions.checkArgument((biz.getIsOpenCrm() != null && biz.getIsOpenCrm() != 0 ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u672a\u5f00\u901aCRM\u529f\u80fd");
        ProductLine record = (ProductLine)this.productLineMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)num)).eq((Object)"is_deleted", (Object)0));
        if (record == null) {
            log.info("productLine not found, bizId={}, num={}", (Object)bizId, (Object)num);
            return null;
        }
        return this.newCrmProductLineResp(record);
    }

    public CrmProductLineResp getById(Long bizId, Long id) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id\u4e3a\u7a7a");
        BizSimpleDto biz = this.scrmBizService.getById(bizId);
        Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Preconditions.checkArgument((biz.getIsOpenCrm() != null && biz.getIsOpenCrm() != 0 ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u672a\u5f00\u901aCRM\u529f\u80fd");
        ProductLine record = (ProductLine)this.productLineMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"id", (Object)id)).eq((Object)"is_deleted", (Object)0));
        if (record == null) {
            log.info("productLine not found, bizId={}, id={}", (Object)bizId, (Object)id);
            return null;
        }
        return this.newCrmProductLineResp(record);
    }

    private CrmProductLineResp newCrmProductLineResp(ProductLine it) {
        CrmProductLineResp dto = new CrmProductLineResp();
        dto.setId(it.getId());
        dto.setNum(it.getNum());
        dto.setName(it.getName());
        return dto;
    }
}

