/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.impl;

import cn.kinyun.crm.common.dto.conf.GuideConf;
import cn.kinyun.crm.common.enums.ConfigType;
import cn.kinyun.crm.common.enums.LeadsFieldSysEnum;
import cn.kinyun.crm.common.service.CrmConfigService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsDictionaryReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsDictionaryResp;
import cn.kinyun.crm.common.service.dto.resp.CrmSalesConfigResp;
import cn.kinyun.crm.dal.config.entity.LeadsConfig;
import cn.kinyun.crm.dal.config.entity.LeadsConfigDetail;
import cn.kinyun.crm.dal.config.mapper.LeadsConfigDetailMapper;
import cn.kinyun.crm.dal.config.mapper.LeadsConfigMapper;
import cn.kinyun.crm.dal.config.mapper.ProductLineMapper;
import cn.kinyun.crm.dal.util.BizTableContext;
import cn.kinyun.crm.sal.conf.service.ProductLineService;
import cn.kinyun.crm.sal.conf.service.SysConfigService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmConfigServiceImpl
implements CrmConfigService {
    private static final Logger log = LoggerFactory.getLogger(CrmConfigServiceImpl.class);
    @Autowired
    private ProductLineMapper productLineMapper;
    @Autowired
    private LeadsConfigMapper leadsConfigMapper;
    @Autowired
    private LeadsConfigDetailMapper leadsConfigDetailMapper;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private ProductLineService productLineService;
    @Autowired
    private SysConfigService sysConfigService;

    public List<CrmLeadsDictionaryResp> getLeadsDictionary(CrmLeadsDictionaryReq params) {
        Integer configType;
        log.info("get leads config, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        String corpId = params.getCorpId();
        BizSimpleDto biz = this.scrmBizService.getByCorpId(corpId);
        Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)("Invalid corpId:" + corpId));
        Preconditions.checkArgument((biz.getIsOpenCrm() != null && biz.getIsOpenCrm() != 0 ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u672a\u5f00\u901aCRM\u529f\u80fd");
        Long bizId = biz.getId();
        BizTableContext.putBizId((Long)bizId);
        Long productLineId = this.productLineService.validateProductLineId(bizId, params.getProductLineId());
        Integer n = params.getIsBusiness() == null ? null : (configType = Integer.valueOf(params.getIsBusiness() != false ? ConfigType.BUSINESS.getValue() : ConfigType.BASE.getValue()));
        Integer isSystem = params.getIsSystem() == null ? null : Integer.valueOf(params.getIsSystem() != false ? 1 : 0);
        List list = this.leadsConfigMapper.queryList(bizId, productLineId, configType, isSystem, Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)list)) {
            BizTableContext.clear();
            return Collections.emptyList();
        }
        List leadsConfigIds = list.stream().map(LeadsConfig::getId).collect(Collectors.toList());
        List detailList = this.leadsConfigDetailMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"leads_config_id", leadsConfigIds));
        Map<Object, Object> detailMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailMap = detailList.stream().collect(Collectors.groupingBy(LeadsConfigDetail::getLeadsConfigId, Collectors.mapping(LeadsConfigDetail::getName, Collectors.toList())));
        }
        HashSet ignore = Sets.newHashSet((Object[])new String[]{"mobile1", "mobile2", "mobile3", "mobile4"});
        ArrayList<CrmLeadsDictionaryResp> result = new ArrayList<CrmLeadsDictionaryResp>(40);
        for (LeadsConfig it : list) {
            if (ignore.contains(it.getFieldName())) continue;
            CrmLeadsDictionaryResp dto = new CrmLeadsDictionaryResp();
            dto.setFieldName(it.getFieldName());
            dto.setDisplayName(it.getName());
            dto.setType(it.getType());
            dto.setIsRequired(it.getIsRequired());
            dto.setOptions((List)detailMap.get(it.getId()));
            result.add(dto);
        }
        return result;
    }

    public boolean openNoRepeat(String corpId, String fieldName) {
        BizSimpleDto biz = this.scrmBizService.getByCorpId(corpId);
        Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)("Invalid corpId:" + corpId));
        Preconditions.checkArgument((biz.getIsOpenCrm() != null && biz.getIsOpenCrm() != 0 ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u672a\u5f00\u901aCRM\u529f\u80fd");
        Long bizId = biz.getId();
        BizTableContext.putBizId((Long)bizId);
        return this.sysConfigService.openNoRepeat(bizId, StringUtils.isBlank((CharSequence)fieldName) ? LeadsFieldSysEnum.NAME.getFieldName() : fieldName);
    }

    public CrmSalesConfigResp getSalesConfig(String corpId) {
        BizSimpleDto biz = this.scrmBizService.getByCorpId(corpId);
        Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)("Invalid corpId:" + corpId));
        Preconditions.checkArgument((biz.getIsOpenCrm() != null && biz.getIsOpenCrm() != 0 ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u672a\u5f00\u901aCRM\u529f\u80fd");
        Long bizId = biz.getId();
        BizTableContext.putBizId((Long)bizId);
        GuideConf guideConf = this.sysConfigService.getGuideConf(bizId);
        Preconditions.checkArgument((guideConf != null && guideConf.checkGuideFinished() ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u5c1a\u672a\u5b8c\u6210\u9500\u552e\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u7ba1\u7406\u5458\u5b8c\u6210\u521d\u59cb\u5316\u64cd\u4f5c\u3002");
        CrmSalesConfigResp result = new CrmSalesConfigResp();
        result.setAllowMultiProductLine(guideConf.getProductLineMulti());
        result.setAllowShuffle(guideConf.getNeedShuffle());
        result.setAllowDeptLib(guideConf.getNeedDeptLib());
        return result;
    }
}

