/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.dto.expression;

import cn.kinyun.crm.common.enums.LeadsFieldSysEnum;
import cn.kinyun.crm.dal.leads.entity.LeadsLib;
import cn.kinyun.crm.dal.util.ReflectUtil;
import cn.kinyun.crm.sal.conf.service.dto.expression.Expression;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class NotNullExpression
implements Expression {
    private String fieldName;

    @Override
    public boolean interpret(LeadsLib leadsLib, List<String> tagIds) {
        List fieldList = ReflectUtil.getAllFieldList((Object)leadsLib);
        switch (this.fieldName) {
            case "gender": {
                return leadsLib.getGender() != null;
            }
            case "age": {
                return leadsLib.getAge() != null && leadsLib.getAge() > 0;
            }
            case "channelId": {
                return leadsLib.getChannelId() != null;
            }
            case "stageId": {
                return leadsLib.getStageId() != null;
            }
            case "market_user_id": {
                return leadsLib.getMarketUserId() != null;
            }
            case "id_num": {
                return leadsLib.getIdNum() != null;
            }
        }
        for (Field field : fieldList) {
            if (!field.getName().equals(this.fieldName)) continue;
            field.setAccessible(true);
            try {
                Object ob = field.get(leadsLib);
                if (!field.getAnnotatedType().getType().equals(String.class) || ob == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(ob))) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (LeadsFieldSysEnum.TAG.getRelateFields().contains(this.fieldName) || LeadsFieldSysEnum.TAG.getFieldName().equals(this.fieldName)) {
            return CollectionUtils.isNotEmpty(tagIds);
        }
        return false;
    }

    public static NotNullExpressionBuilder builder() {
        return new NotNullExpressionBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotNullExpression)) {
            return false;
        }
        NotNullExpression other = (NotNullExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotNullExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        return result;
    }

    public String toString() {
        return "NotNullExpression(fieldName=" + this.getFieldName() + ")";
    }

    public NotNullExpression(String fieldName) {
        this.fieldName = fieldName;
    }

    public NotNullExpression() {
    }

    public static class NotNullExpressionBuilder {
        private String fieldName;

        NotNullExpressionBuilder() {
        }

        public NotNullExpressionBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public NotNullExpression build() {
            return new NotNullExpression(this.fieldName);
        }

        public String toString() {
            return "NotNullExpression.NotNullExpressionBuilder(fieldName=" + this.fieldName + ")";
        }
    }
}

