/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.dto.expression;

import cn.kinyun.crm.common.enums.LeadsFieldSysEnum;
import cn.kinyun.crm.dal.leads.entity.LeadsLib;
import cn.kinyun.crm.dal.util.ReflectUtil;
import cn.kinyun.crm.sal.conf.service.dto.expression.Expression;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IsNullExpression
implements Expression {
    private String fieldName;

    @Override
    public boolean interpret(LeadsLib leadsLib, List<String> tagIds) {
        List fieldList = ReflectUtil.getAllFieldList((Object)leadsLib);
        switch (this.fieldName) {
            case "gender": {
                return leadsLib.getGender() == null;
            }
            case "age": {
                return leadsLib.getAge() == null || leadsLib.getAge() <= 0;
            }
            case "channelId": {
                return leadsLib.getChannelId() == null;
            }
            case "stageId": {
                return leadsLib.getStageId() == null;
            }
            case "market_user_id": {
                return leadsLib.getMarketUserId() == null;
            }
            case "id_num": {
                return leadsLib.getIdNum() != null;
            }
        }
        for (Field field : fieldList) {
            if (!field.getName().equals(this.fieldName)) continue;
            field.setAccessible(true);
            try {
                Object ob = field.get(leadsLib);
                if (!field.getAnnotatedType().getType().equals(String.class) || ob != null && !StringUtils.isBlank((CharSequence)String.valueOf(ob))) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (LeadsFieldSysEnum.TAG.getRelateFields().contains(this.fieldName) || LeadsFieldSysEnum.TAG.getFieldName().equals(this.fieldName)) {
            return CollectionUtils.isEmpty(tagIds);
        }
        return false;
    }

    public static IsNullExpressionBuilder builder() {
        return new IsNullExpressionBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IsNullExpression)) {
            return false;
        }
        IsNullExpression other = (IsNullExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IsNullExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        return result;
    }

    public String toString() {
        return "IsNullExpression(fieldName=" + this.getFieldName() + ")";
    }

    public IsNullExpression(String fieldName) {
        this.fieldName = fieldName;
    }

    public IsNullExpression() {
    }

    public static class IsNullExpressionBuilder {
        private String fieldName;

        IsNullExpressionBuilder() {
        }

        public IsNullExpressionBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public IsNullExpression build() {
            return new IsNullExpression(this.fieldName);
        }

        public String toString() {
            return "IsNullExpression.IsNullExpressionBuilder(fieldName=" + this.fieldName + ")";
        }
    }
}

