/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.conf.service.dto.expression;

import cn.kinyun.crm.dal.leads.entity.LeadsLib;
import cn.kinyun.crm.dal.util.ReflectUtil;
import cn.kinyun.crm.sal.conf.service.dto.expression.Expression;
import java.lang.reflect.Field;
import java.util.List;

public class GeExpression
implements Expression {
    private String fieldName;
    private Object value;

    @Override
    public boolean interpret(LeadsLib leadsLib, List<String> tagIds) {
        if (this.value == null) {
            return false;
        }
        List fieldList = ReflectUtil.getAllFieldList((Object)leadsLib);
        for (Field field : fieldList) {
            if (!field.getName().equals(this.fieldName)) continue;
            field.setAccessible(true);
            try {
                Number fieldValue;
                if (this.value == null) {
                    return false;
                }
                if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                    fieldValue = field.getLong(leadsLib);
                    if (fieldValue == null) continue;
                    return (Long)fieldValue >= (Long)this.value;
                }
                if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                    fieldValue = field.getInt(leadsLib);
                    if (fieldValue == null) continue;
                    return (Integer)fieldValue >= (Integer)this.value;
                }
                if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                    fieldValue = field.getDouble(leadsLib);
                    if (fieldValue == null) continue;
                    return (Double)fieldValue >= (Double)this.value;
                }
                if (field.getType() != Float.class && field.getType() != Float.TYPE || (fieldValue = Float.valueOf(field.getFloat(leadsLib))) == null) continue;
                return ((Float)fieldValue).floatValue() >= ((Float)this.value).floatValue();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static GeExpressionBuilder builder() {
        return new GeExpressionBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeExpression)) {
            return false;
        }
        GeExpression other = (GeExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "GeExpression(fieldName=" + this.getFieldName() + ", value=" + this.getValue() + ")";
    }

    public GeExpression(String fieldName, Object value) {
        this.fieldName = fieldName;
        this.value = value;
    }

    public GeExpression() {
    }

    public static class GeExpressionBuilder {
        private String fieldName;
        private Object value;

        GeExpressionBuilder() {
        }

        public GeExpressionBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public GeExpressionBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public GeExpression build() {
            return new GeExpression(this.fieldName, this.value);
        }

        public String toString() {
            return "GeExpression.GeExpressionBuilder(fieldName=" + this.fieldName + ", value=" + this.value + ")";
        }
    }
}

