/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service.dto.req;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * desc: 线索
 *
 * @author yanmaoyuan
 * @date 2021/10/17
 */
@Data
public class CrmLeadsReq implements Serializable {

    private Integer allocRule;// 1-交给客服清洗;2-分配进个人临时库;3-分配进部门公海;4-进入公海
    private Long allocUserId;// 分配给指定用户
    private String allocUserIds;
    private Long allocNodeId;// 分配部门ID（当分配规则选择分配给部门公海时必填）。
    // 是否关联企微
    private Integer isAssociateWework;

    private Long bizId;
    private Long leadId;

    private String corpId;// 企业ID
    private Long creatorId;// 创建人ID

    private String name;// 姓名
    private String mobile;// 手机号（必填）
    private String mobile1;
    private String newMobile;
    private String newMobile1;
    private Long productLineId;// 销售线ID（不传默认销售线）

    private Long channelId;// 数据渠道ID
    private Long marketUserId;// 推广人ID

    private List<String> tagIds;// 标签ID

    // 客户信息字段
    private String idNum;// 身份证号
    private String areaId;// 所在城市,采用国家行政编码，例如 "武汉市" -> 420100
    private Integer gender;// 性别,0-未定义，1-男性，2-女性
    private String qq;// QQ号
    private String wechat;// 微信号
    private String mail;// 邮箱
    private Integer age;// 年龄
    private String remark;// 备注
    private String education;// 学历
    private String graduated;// 毕业院校
    private String major;// 专业

    // 自定义字段
    private String p1;
    private String p2;
    private String p3;
    private String p4;
    private String p5;
    private String p6;
    private String p7;
    private String p8;
    private String p9;
    private String p10;
    private String p11;
    private String p12;
    private String p13;
    private String p14;
    private String p15;
    private String p16;
    private String p17;
    private String p18;
    private String p19;
    private String p20;

    private String extType;// 客户自定义数据类型
    private String extValue;// 客户自定义数据内容

    // 是否使用严格的字段校验，默认关闭
    // 若开启此选项，将根据数据字典检查必填字段、字段内容。
    private Boolean useStrictValidation;
    private Integer sourceType;

    // 定制信息
    private Integer ruleType;// 规则类型 0 默认 1 网校定制

    /**
     * 是否允许库容溢出
     */
    private Integer libCapacityLimited;

    /**
     * 金额足够分配到成交库
     */
    private Integer fullAmountCustomerType;

    /**
     * 用户指定保存到零时库还是私有库
     */
    private Integer allocTargetCustomerType;

    private Long tradeAmount;

    /**
     * 是否覆盖字段值
     */
    private Integer coverFieldValue;

    // 知阅
    private String birthday;// 生日
    private String schoolId;// 所属校区
    private String schoolName;// 所属校区
    private Integer registerStatus;// 注册状态
    private String unionID;// unionID

}
