package cn.kinyun.crm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 线索导入时，用户选择的分配规则
 *
 * @author yanmaoyuan
 * @date 2021/9/2
 */
public enum RawLeadsAllocRule {

    CUSTOMER_SERVICE(1, "客服团队清洗"),

    PRIVATE(2, "平均分配到个人"),

    DEPARTMENT(3, "分配到部门"),

    PUBLIC(4, "分配到公海"),

    INNER_SYSTEM(5, "数据互通分配"),

    ;

    private final int value;

    private final String desc;

    RawLeadsAllocRule(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private final static Map<Integer, RawLeadsAllocRule> CACHE;

    static {
        Map<Integer, RawLeadsAllocRule> map = new HashMap<>();
        for (RawLeadsAllocRule e : values()) {
            map.put(e.value, e);
        }
        CACHE = map;
    }

    public static RawLeadsAllocRule getType(Integer value) {
        return CACHE.get(value);
    }
}
