package cn.kinyun.crm.common.enums;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * 线索分配对象
 *
 * @author luoxingke
 * @date 2021-08-29 16:15
 */
public enum SourceType implements EnumService {

    MANUAL(0, "","手动录入",""),
    BATCH_IMPORT(1, "","批量导入",""),
    API(2, "","系统对接",""),
    SCRM_SYNC(3, "qyweixin","系统对接-企业微信","通过在微信客户详情或者企微侧边栏备注手机号，或通过手机号添加微信好友产生的新线索"),
    TRADE_SYNC(4, "orderCenter","系统对接-订单中心","通过订单中心录入订单，订单手机号经过排重产生的新线索"),
    AD_SYNC(5, "adDeliver","系统对接-广告投放","通过广告投放功能收集到的手机号线索"),
    DYNAMIC_FORM_SYNC(6, "dynamicForm","系统对接-动态表单","通过动态表单功能收集到的手机号线索"),
    LIVE_COMMERCE(7, "liveCommerce","系统对接-直播带货","通过直播带货获取到的手机号线索")
    ;

    private final int value;

    private final String code;

    private final String desc;

    private final String explain;

    SourceType(int value, String code,String desc,String explain) {
        this.value = value;
        this.code = code;
        this.desc = desc;
        this.explain = explain;
    }

    public int getValue() {
        return value;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
    public String getExplain() {
        return explain;
    }

    private final static Map<Integer, SourceType> CACHE;

    static {
        Map<Integer, SourceType> map = new HashMap<>();
        for (SourceType e : values()) {
            map.put(e.value, e);
        }
        CACHE = map;
    }

    public static SourceType getType(Integer value) {
        return CACHE.get(value);
    }
    public static String getTypeDesc(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Optional.ofNullable(CACHE.get(value)).map(SourceType::getDesc).orElse("");
    }
    public static String getTypeExplain(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Optional.ofNullable(CACHE.get(value)).map(SourceType::getExplain).orElse("");

    }
}
